/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.env;

import org.jbpm.pvm.internal.cfg.JbpmConfiguration;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.xml.WireParser;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JbpmConfigurationParser
extends Parser {
    private static final long serialVersionUID = 1L;
    Parser processEngineContextParser = new WireParser();
    Parser transactionContextParser = new WireParser();
    protected static JbpmConfigurationParser INSTANCE = new JbpmConfigurationParser();

    public static JbpmConfigurationParser getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseDocument(Document document, Parse parse) {
        Element txCtxElement;
        Element documentElement = document.getDocumentElement();
        JbpmConfiguration jbpmConfiguration = parse.findObject(JbpmConfiguration.class);
        if (jbpmConfiguration == null) {
            jbpmConfiguration = new JbpmConfiguration();
        }
        for (Element importElement : XmlUtil.elements(documentElement, "import")) {
            if (!importElement.hasAttribute("resource")) continue;
            String resource = importElement.getAttribute("resource");
            Parse importParse = this.createParse().setResource(resource).pushObject(jbpmConfiguration).execute();
            parse.addProblems(importParse.getProblems());
        }
        Element processEngineElement = XmlUtil.element(documentElement, "process-engine-context");
        if (processEngineElement != null) {
            WireDefinition processEngineContextDefinition = jbpmConfiguration.getProcessEngineWireContext().getWireDefinition();
            parse.pushObject(processEngineContextDefinition);
            try {
                this.processEngineContextParser.parseDocumentElement(processEngineElement, parse);
            }
            finally {
                parse.popObject();
            }
        }
        if ((txCtxElement = XmlUtil.element(documentElement, "transaction-context")) != null) {
            WireDefinition transactionContextDefinition = jbpmConfiguration.getTransactionWireDefinition();
            parse.pushObject(transactionContextDefinition);
            try {
                this.transactionContextParser.parseDocumentElement(txCtxElement, parse);
            }
            finally {
                parse.popObject();
            }
        }
        parse.setDocumentObject(jbpmConfiguration);
        return jbpmConfiguration;
    }

    public Parser getProcessEngineContextParser() {
        return this.processEngineContextParser;
    }

    public void setProcessEngineContextParser(Parser applicationWireXmlParser) {
        this.processEngineContextParser = applicationWireXmlParser;
    }

    public Parser getTransactionContextParser() {
        return this.transactionContextParser;
    }

    public void setTransactionContextParser(Parser blockWireXmlParser) {
        this.transactionContextParser = blockWireXmlParser;
    }
}

