/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.metadata.ClassMetadata;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.history.HistoryComment;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.client.ClientExecution;
import org.jbpm.pvm.internal.client.ClientProcessDefinition;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.history.model.HistoryCommentImpl;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceImpl;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.query.DeploymentQueryImpl;
import org.jbpm.pvm.internal.query.HistoryActivityInstanceQueryImpl;
import org.jbpm.pvm.internal.query.HistoryProcessInstanceQueryImpl;
import org.jbpm.pvm.internal.query.JobQueryImpl;
import org.jbpm.pvm.internal.query.ProcessInstanceQueryImpl;
import org.jbpm.pvm.internal.query.TaskQueryImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSessionImpl
implements DbSession {
    private static Log log = Log.getLog((String)DbSessionImpl.class.getName());
    protected Session session;

    public void close() {
        this.session.close();
    }

    @Override
    public <T> T get(Class<T> entityClass, Object primaryKey) {
        return entityClass.cast(this.session.get(entityClass, (Serializable)primaryKey));
    }

    @Override
    public void flush() {
        this.session.flush();
    }

    public void forceVersionUpdate(Object entity) {
        this.session.lock(entity, LockMode.FORCE);
    }

    public void lockPessimistically(Object entity) {
        this.session.lock(entity, LockMode.UPGRADE);
    }

    @Override
    public void save(Object entity) {
        this.session.save(entity);
    }

    @Override
    public void update(Object entity) {
        this.session.update(entity);
    }

    public void merge(Object entity) {
        this.session.merge(entity);
    }

    @Override
    public void delete(Object entity) {
        this.session.delete(entity);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public List<String> findProcessDefinitionKeys() {
        return this.session.getNamedQuery("findProcessDefinitionKeys").list();
    }

    @Override
    public ClientProcessDefinition findLatestProcessDefinitionByKey(String processDefinitionKey) {
        Query query = this.session.getNamedQuery("findProcessDefinitionsByKey");
        query.setString("key", processDefinitionKey);
        query.setMaxResults(1);
        ClientProcessDefinition processDefinition = (ClientProcessDefinition)query.uniqueResult();
        return processDefinition;
    }

    @Override
    public List<ClientProcessDefinition> findProcessDefinitionsByKey(String processDefinitionKey) {
        Query query = this.session.getNamedQuery("findProcessDefinitionsByKey");
        query.setString("key", processDefinitionKey);
        return query.list();
    }

    @Override
    public ClientProcessDefinition findProcessDefinitionById(String processDefinitionId) {
        Query query = this.session.getNamedQuery("findProcessDefinitionById");
        query.setString("id", processDefinitionId);
        query.setMaxResults(1);
        ClientProcessDefinition processDefinition = (ClientProcessDefinition)query.uniqueResult();
        return processDefinition;
    }

    @Override
    public void deleteProcessDefinition(String processDefinitionId, boolean deleteProcessInstances, boolean deleteHistory) {
        List<String> processInstanceIds = this.findProcessInstanceIds(processDefinitionId);
        if (deleteHistory && this.isHistoryEnabled()) {
            List historyProcessInstances = this.createHistoryProcessInstanceQuery().processDefinitionId(processDefinitionId).list();
            for (HistoryProcessInstance historyProcessInstance : historyProcessInstances) {
                this.session.delete((Object)historyProcessInstance);
            }
        }
        if (deleteProcessInstances) {
            for (String processInstanceId : processInstanceIds) {
                this.deleteProcessInstance(processInstanceId, deleteHistory);
            }
        } else if (processInstanceIds.size() > 0) {
            throw new JbpmException("still " + processInstanceIds.size() + " process instances for process definition " + processDefinitionId);
        }
        ClientProcessDefinition processDefinition = this.findProcessDefinitionById(processDefinitionId);
        this.session.delete((Object)processDefinition);
    }

    @Override
    public void deleteProcessDefinitionHistory(String processDefinitionId) {
        List historyProcessInstances = this.session.createQuery("select hpi from " + HistoryProcessInstanceImpl.class.getName() + " hpi " + "where hpi.processDefinitionId = :processDefinitionId ").setString("processDefinitionId", processDefinitionId).list();
        for (HistoryProcessInstanceImpl hpi : historyProcessInstances) {
            this.session.delete((Object)hpi);
        }
    }

    public boolean isHistoryEnabled() {
        ClassMetadata historyHibernateMetadata = this.session.getSessionFactory().getClassMetadata(HistoryProcessInstanceImpl.class);
        return historyHibernateMetadata != null;
    }

    @Override
    public ClientExecution findExecutionById(String executionId) {
        Query query = this.session.getNamedQuery("findExecutionById");
        query.setString("id", executionId);
        query.setMaxResults(1);
        return (ClientExecution)query.uniqueResult();
    }

    @Override
    public ClientExecution findProcessInstanceById(String processInstanceId) {
        Query query = this.session.getNamedQuery("findProcessInstanceById");
        query.setString("processInstanceId", processInstanceId);
        query.setMaxResults(1);
        return (ClientExecution)query.uniqueResult();
    }

    public ClientExecution findProcessInstanceByIdIgnoreSuspended(String processInstanceId) {
        Query query = this.session.getNamedQuery("findProcessInstanceByIdIgnoreSuspended");
        query.setString("processInstanceId", processInstanceId);
        query.setMaxResults(1);
        return (ClientExecution)query.uniqueResult();
    }

    @Override
    public List<String> findProcessInstanceIds(String processDefinitionId) {
        Query query = this.session.createQuery("select processInstance.id from org.jbpm.pvm.internal.model.ExecutionImpl as processInstance where processInstance.processDefinitionId = :processDefinitionId   and processInstance.parent is null");
        query.setString("processDefinitionId", processDefinitionId);
        return query.list();
    }

    public void deleteProcessInstance(String processInstanceId) {
        this.deleteProcessInstance(processInstanceId, true);
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, boolean deleteHistory) {
        ExecutionImpl processInstance;
        HistoryProcessInstanceImpl historyProcessInstance;
        if (processInstanceId == null) {
            throw new JbpmException("processInstanceId is null");
        }
        if (deleteHistory && this.isHistoryEnabled() && (historyProcessInstance = this.findHistoryProcessInstanceById(processInstanceId)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("deleting history process instance " + processInstanceId);
            }
            this.session.delete((Object)historyProcessInstance);
        }
        if ((processInstance = (ExecutionImpl)this.findProcessInstanceByIdIgnoreSuspended(processInstanceId)) != null) {
            List<TaskImpl> tasks = this.findTasks(processInstanceId);
            for (TaskImpl task : tasks) {
                this.session.delete((Object)task);
            }
            JobImpl currentJob = Environment.getFromCurrent(JobImpl.class, false);
            List<JobImpl> jobs = this.findJobs(processInstanceId);
            for (JobImpl job : jobs) {
                if (job == currentJob) continue;
                this.session.delete((Object)job);
            }
            if (log.isDebugEnabled()) {
                log.debug("deleting process instance " + processInstanceId);
            }
            this.session.delete((Object)processInstance);
        }
    }

    public HistoryProcessInstanceImpl findHistoryProcessInstanceById(String processInstanceId) {
        return (HistoryProcessInstanceImpl)this.session.createQuery("select hpi from " + HistoryProcessInstance.class.getName() + " as hpi " + "where hpi.processInstanceId = '" + processInstanceId + "'").uniqueResult();
    }

    List<TaskImpl> findTasks(String processInstanceId) {
        Query query = this.session.createQuery("select task from " + TaskImpl.class.getName() + " as task " + "where task.processInstance.id = :processInstanceId");
        query.setString("processInstanceId", processInstanceId);
        return query.list();
    }

    List<JobImpl> findJobs(String processInstanceId) {
        Query query = this.session.createQuery("select job from " + JobImpl.class.getName() + " as job " + "where job.processInstance.id = :processInstanceId");
        query.setString("processInstanceId", processInstanceId);
        return query.list();
    }

    @Override
    public void cascadeExecutionSuspend(ExecutionImpl execution) {
        Query query = this.session.createQuery("select job from " + JobImpl.class.getName() + " as job " + "where job.execution = :execution " + "  and job.state != '" + "suspended" + "' ");
        query.setEntity("execution", (Object)execution);
        List jobs = query.list();
        for (JobImpl job : jobs) {
            job.suspend();
        }
        query = this.session.createQuery("select task from " + TaskImpl.class.getName() + " as task " + "where task.execution = :execution " + "  and task.state != '" + "suspended" + "' ");
        query.setEntity("execution", (Object)execution);
        List tasks = query.list();
        for (TaskImpl task : tasks) {
            task.suspend();
        }
    }

    @Override
    public void cascadeExecutionResume(ExecutionImpl execution) {
        Query query = this.session.createQuery("select job from " + JobImpl.class.getName() + " as job " + "where job.execution = :execution " + "  and job.state = '" + "suspended" + "' ");
        query.setEntity("execution", (Object)execution);
        List jobs = query.list();
        for (JobImpl job : jobs) {
            job.resume();
        }
        query = this.session.createQuery("select task from " + TaskImpl.class.getName() + " as task " + "where task.execution = :execution " + "  and task.state = '" + "suspended" + "' ");
        query.setEntity("execution", (Object)execution);
        List tasks = query.list();
        for (TaskImpl task : tasks) {
            task.resume();
        }
    }

    @Override
    public TaskImpl createTask() {
        TaskImpl task = this.newTask();
        task.setCreateTime(Clock.getCurrentTime());
        return task;
    }

    protected TaskImpl newTask() {
        TaskImpl task = new TaskImpl();
        task.setNew(true);
        return task;
    }

    public TaskImpl findTaskByDbid(long taskDbid) {
        return (TaskImpl)this.session.get(TaskImpl.class, (Serializable)Long.valueOf(taskDbid));
    }

    @Override
    public TaskImpl findTaskByExecution(Execution execution) {
        Query query = this.session.createQuery("select task from " + TaskImpl.class.getName() + " as task " + "where task.execution = :execution");
        query.setEntity("execution", (Object)execution);
        return (TaskImpl)query.uniqueResult();
    }

    @Override
    public JobImpl<?> findFirstAcquirableJob() {
        Query query = this.session.getNamedQuery("findFirstAcquirableJob");
        query.setTimestamp("now", Clock.getCurrentTime());
        query.setMaxResults(1);
        return (JobImpl)query.uniqueResult();
    }

    @Override
    public List<JobImpl<?>> findExclusiveJobs(Execution processInstance) {
        Query query = this.session.getNamedQuery("findExclusiveJobs");
        query.setTimestamp("now", Clock.getCurrentTime());
        query.setEntity("processInstance", (Object)processInstance);
        return query.list();
    }

    @Override
    public JobImpl<?> findFirstDueJob() {
        Query query = this.session.getNamedQuery("findFirstDueJob");
        query.setMaxResults(1);
        return (JobImpl)query.uniqueResult();
    }

    @Override
    public ProcessInstanceQueryImpl createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl();
    }

    @Override
    public TaskQueryImpl createTaskQuery() {
        return new TaskQueryImpl();
    }

    @Override
    public HistoryProcessInstanceQueryImpl createHistoryProcessInstanceQuery() {
        return new HistoryProcessInstanceQueryImpl();
    }

    @Override
    public HistoryActivityInstanceQueryImpl createHistoryActivityInstanceQuery() {
        return new HistoryActivityInstanceQueryImpl();
    }

    @Override
    public JobQueryImpl createJobQuery() {
        return new JobQueryImpl();
    }

    @Override
    public DeploymentQueryImpl createDeploymentQuery() {
        return new DeploymentQueryImpl();
    }

    @Override
    public List<HistoryComment> findCommentsByTaskId(String taskId) {
        Long taskDbid = null;
        try {
            taskDbid = Long.parseLong(taskId);
        }
        catch (Exception e) {
            throw new JbpmException("invalid taskId: " + taskId);
        }
        return this.session.createQuery("select hc from " + HistoryCommentImpl.class.getName() + " as hc " + "where hc.historyTask.dbid = :taskDbid " + "order by hc.historyTaskIndex asc ").setLong("taskDbid", taskDbid.longValue()).list();
    }
}

