/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.api.history.HistoryActivityInstance;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.pvm.internal.history.model.HistoryDetailImpl;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;

public class HistoryActivityInstanceImpl
implements HistoryActivityInstance,
Serializable {
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected int dbversion;
    protected HistoryProcessInstance historyProcessInstance;
    protected String executionId;
    protected ActivityImpl activity;
    protected String type;
    protected String activityName;
    protected Date startTime;
    protected Date endTime;
    protected long duration;
    protected String transitionName;
    protected int nextDetailIndex = 1;
    protected Set<HistoryDetailImpl> details = new HashSet<HistoryDetailImpl>();

    public HistoryActivityInstanceImpl() {
    }

    public HistoryActivityInstanceImpl(HistoryProcessInstance historyProcessInstanceImpl, ExecutionImpl execution) {
        this.historyProcessInstance = historyProcessInstanceImpl;
        this.activity = execution.getActivity();
        this.executionId = execution.getId();
        this.activityName = this.activity.getName();
        this.startTime = execution.getHistoryActivityStart();
    }

    public void addDetail(HistoryDetailImpl detail) {
        detail.setHistoryActivityInstance(this, this.nextDetailIndex);
        ++this.nextDetailIndex;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        this.duration = endTime.getTime() - this.startTime.getTime();
    }

    public long getDbid() {
        return this.dbid;
    }

    public ActivityImpl getActivity() {
        return this.activity;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public HistoryProcessInstance getHistoryProcessInstance() {
        return this.historyProcessInstance;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

