/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.pvm.internal.history.model.HistoryDetailImpl;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskImpl;
import org.jbpm.pvm.internal.history.model.HistoryVariableUpdateImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.type.Variable;

public class HistoryVariableImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected int dbversion;
    protected HistoryProcessInstanceImpl historyProcessInstance;
    protected HistoryTaskImpl historyTask;
    protected String processInstanceId;
    protected String executionId;
    protected String variableName;
    protected String value;
    protected int nextDetailIndex = 1;
    protected Set<HistoryDetailImpl> details = new HashSet<HistoryDetailImpl>();

    protected HistoryVariableImpl() {
    }

    public HistoryVariableImpl(HistoryProcessInstanceImpl historyProcessInstance, HistoryTaskImpl historyTask, Variable variable) {
        this.dbid = variable.getDbid();
        this.historyProcessInstance = historyProcessInstance;
        this.historyTask = historyTask;
        ExecutionImpl processInstance = variable.getProcessInstance();
        if (processInstance != null) {
            this.processInstanceId = processInstance.getId();
        }
        this.variableName = variable.getKey();
        this.value = variable.getTextValue();
    }

    public void updated(Variable variable) {
        String newValue = variable.getTextValue();
        if (this.value == null && newValue != null || this.value != null && !this.value.equals(newValue)) {
            this.addDetail(new HistoryVariableUpdateImpl(this.value, newValue));
        }
    }

    public void addDetail(HistoryDetailImpl detail) {
        detail.setHistoryVariable(this, this.nextDetailIndex);
        ++this.nextDetailIndex;
    }
}

