/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.job;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jbpm.api.JbpmException;
import org.jbpm.api.job.Timer;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cal.BusinessCalendar;
import org.jbpm.pvm.internal.cal.Duration;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.env.EnvironmentDefaults;
import org.jbpm.pvm.internal.env.Transaction;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.jobexecutor.JobAddedNotification;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.script.ScriptManager;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.session.TimerSession;
import org.jbpm.pvm.internal.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerImpl
extends JobImpl<Boolean>
implements Timer {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)TimerImpl.class.getName());
    private static final String dateFormat = "yyyy-MM-dd HH:mm:ss,SSS";
    protected String signalName;
    protected String eventName;
    protected String repeat;
    public static final String EVENT_TIMER = "timer";

    public void schedule() {
        TimerSession timerSession = Environment.getFromCurrent(TimerSession.class);
        timerSession.schedule(this);
    }

    public void setDueDateDescription(String dueDateDescription) {
        ScriptManager scriptManager = EnvironmentDefaults.getScriptManager();
        dueDateDescription = (String)scriptManager.evaluateExpression(dueDateDescription, null);
        Duration duration = new Duration(dueDateDescription);
        Date now = Clock.getCurrentTime();
        if (duration.isBusinessTime() || duration.getMonths() > 0 || duration.getYears() > 0) {
            Environment environment = Environment.getCurrent();
            if (environment == null) {
                throw new JbpmException("no environment to get business calendar for calculating duedate " + dueDateDescription);
            }
            BusinessCalendar businessCalendar = environment.get(BusinessCalendar.class);
            this.dueDate = businessCalendar.add(now, duration);
        } else {
            long millis = duration.getMillis() + 1000 * (duration.getSeconds() + 60 * (duration.getMinutes() + 60 * (duration.getHours() + 24 * (duration.getDays() + 7 * duration.getWeeks()))));
            this.dueDate = new Date(now.getTime() + millis);
        }
    }

    @Override
    public Boolean execute(Environment environment) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("executing " + this);
        }
        if (environment == null) {
            throw new JbpmException("environment is null");
        }
        if (this.signalName != null) {
            if (log.isDebugEnabled()) {
                log.debug("feeding timer signal " + this.signalName + " into " + this.execution);
            }
            this.execution.signal(this.signalName);
        }
        if (this.eventName != null) {
            ActivityImpl eventSource = this.execution.getActivity();
            if (log.isDebugEnabled()) {
                log.debug("firing event " + this.signalName + " into " + eventSource);
            }
            this.execution.fire(this.eventName, eventSource);
        }
        boolean deleteThisJob = true;
        if (this.repeat == null) {
            DbSession dbSession;
            if (log.isDebugEnabled()) {
                log.debug("deleting " + this);
            }
            if ((dbSession = environment.get(DbSession.class)) == null) {
                throw new JbpmException("no " + DbSession.class.getName() + " in environment");
            }
            dbSession.delete(this);
        } else {
            deleteThisJob = false;
            do {
                this.setDueDateDescription(this.repeat);
            } while (this.dueDate.getTime() <= Clock.getCurrentTime().getTime());
            if (log.isDebugEnabled()) {
                log.debug("rescheduled " + this + " for " + TimerImpl.formatDueDate(this.dueDate));
            }
            this.release();
            JobExecutor jobExecutor = environment.get(JobExecutor.class);
            if (jobExecutor != null) {
                Transaction transaction = environment.get(Transaction.class);
                if (transaction == null) {
                    throw new JbpmException("no transaction in environment");
                }
                JobAddedNotification jobNotificator = new JobAddedNotification(jobExecutor);
                transaction.registerSynchronization(jobNotificator);
            }
        }
        return deleteThisJob;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("timer[");
        text.append(this.dbid);
        if (this.dueDate != null) {
            text.append("|");
            text.append(TimerImpl.formatDueDate(this.dueDate));
        }
        if (this.signalName != null) {
            text.append("|");
            text.append(this.signalName);
        }
        if (this.eventName != null) {
            text.append("|");
            text.append(this.eventName);
        }
        text.append("]");
        return text.toString();
    }

    public static String formatDueDate(Date date) {
        return new SimpleDateFormat(dateFormat).format(date);
    }

    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }
}

