/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.util.Collection;
import java.util.Date;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatcherThread
extends Thread {
    private static final Log log = Log.getLog((String)DispatcherThread.class.getName());
    protected JobExecutor jobExecutor;
    protected boolean isActive = true;
    protected boolean checkForNewJobs;
    protected int currentIdleInterval;
    protected Object semaphore = new Object();

    protected DispatcherThread(JobExecutor jobExecutor) {
        this(jobExecutor, "DispatcherThread");
    }

    protected DispatcherThread(JobExecutor jobExecutor, String name) {
        super(name);
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block22: {
            log.info("starting...");
            this.currentIdleInterval = this.jobExecutor.getIdleMillis();
            block16: while (true) {
                try {
                    while (this.isActive) {
                        try {
                            long waitPeriod;
                            this.checkForNewJobs = false;
                            Collection<Long> acquiredJobDbids = this.acquireJobs();
                            this.currentIdleInterval = this.jobExecutor.getIdleMillis();
                            if (acquiredJobDbids != null && !acquiredJobDbids.isEmpty()) {
                                this.putAcquiredJobDbidsOnQueue(acquiredJobDbids);
                                log.debug("added jobs " + acquiredJobDbids + " to the queue");
                                continue block16;
                            }
                            if (!this.isActive || (waitPeriod = this.getWaitPeriod()) <= 0L) continue block16;
                            Object object = this.semaphore;
                            synchronized (object) {
                                if (!this.checkForNewJobs) {
                                    log.debug(this.getName() + " will wait for max " + waitPeriod + "ms on " + this.jobExecutor);
                                    this.semaphore.wait(waitPeriod);
                                    log.debug(this.getName() + " woke up");
                                } else {
                                    log.debug("skipped wait because new message arrived");
                                }
                                continue block16;
                            }
                        }
                        catch (InterruptedException e) {
                            log.info((this.isActive ? "active" : "inactivated") + " job dispatcher thread '" + this.getName() + "' got interrupted");
                        }
                        catch (Exception e) {
                            log.error("exception in job executor thread. waiting " + this.currentIdleInterval + " milliseconds", (Throwable)e);
                            try {
                                Object waitPeriod = this.semaphore;
                                synchronized (waitPeriod) {
                                    this.semaphore.wait(this.currentIdleInterval);
                                }
                            }
                            catch (InterruptedException e2) {
                                log.trace("delay after exception got interrupted", (Throwable)e2);
                            }
                            this.currentIdleInterval *= 2;
                        }
                    }
                    break block22;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    break block22;
                }
            }
            finally {
                log.info(this.getName() + " leaves cyberspace");
            }
        }
    }

    protected void putAcquiredJobDbidsOnQueue(Collection<Long> acquiredJobDbids) {
        log.debug("pushing jobs on the queue " + acquiredJobDbids);
        while (acquiredJobDbids != null) {
            try {
                this.jobExecutor.getJobDbidsQueue().put(acquiredJobDbids);
                log.trace("jobs " + acquiredJobDbids + " were put on the queue");
                acquiredJobDbids = null;
            }
            catch (InterruptedException e) {
                log.trace("putting acquired job dbids got interrupted. retrying...");
            }
        }
    }

    protected Collection<Long> acquireJobs() {
        CommandService commandService = this.jobExecutor.getCommandExecutor();
        Command<Collection<Long>> acquireJobsCommand = this.jobExecutor.getAcquireJobsCommand();
        return commandService.execute(acquireJobsCommand);
    }

    protected Date getNextDueDate() {
        CommandService commandService = this.jobExecutor.getCommandExecutor();
        Command<Date> getNextDueDate = this.jobExecutor.getNextDueDateCommand();
        return commandService.execute(getNextDueDate);
    }

    protected long getWaitPeriod() {
        long interval = this.jobExecutor.getIdleMillis();
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTimeMillis = System.currentTimeMillis();
            long nextDueDateTime = nextDueDate.getTime();
            if (nextDueDateTime < currentTimeMillis + (long)this.currentIdleInterval) {
                interval = nextDueDateTime - currentTimeMillis;
            }
        }
        if (interval < 0L) {
            interval = 0L;
        }
        return interval;
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean join) {
        if (this.isActive) {
            log.debug("deactivating " + this.getName());
            this.isActive = false;
            this.interrupt();
            if (join) {
                while (this.isAlive()) {
                    try {
                        log.debug("joining " + this.getName());
                        this.join();
                    }
                    catch (InterruptedException e) {
                        log.trace("joining " + this.getName() + " got interrupted");
                    }
                }
            }
        } else {
            log.trace("ignoring deactivate: " + this.getName() + " is not active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        log.trace("notifying job executor dispatcher thread of new job");
        Object object = this.semaphore;
        synchronized (object) {
            this.checkForNewJobs = true;
            this.semaphore.notify();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }
}

