/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.transaction.Synchronization;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.env.Transaction;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.jobexecutor.JobAddedNotification;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExceptionHandler
implements Synchronization,
Command<Object> {
    private static final Log log = Log.getLog((String)JobExceptionHandler.class.getName());
    private static final long serialVersionUID = 1L;
    protected CommandService commandService;
    protected long jobDbid;
    protected Throwable exception;

    public JobExceptionHandler(long jobDbid, Throwable exception, CommandService commandService) {
        this.commandService = commandService;
        this.jobDbid = jobDbid;
        this.exception = exception;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        log.debug("starting new transaction for handling job exception");
        this.commandService.execute(this);
        log.debug("completed transaction for handling job exception");
    }

    @Override
    public Object execute(Environment environment) throws Exception {
        log.debug("handling job " + this.jobDbid + " exception: " + this.exception.getMessage());
        DbSession dbSession = environment.get(DbSession.class);
        if (dbSession == null) {
            throw new JbpmException("no job-session configured to handle job");
        }
        JobImpl job = dbSession.get(JobImpl.class, this.jobDbid);
        StringWriter sw = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(sw));
        if (job != null) {
            int decrementedRetries = job.getRetries() - 1;
            log.debug("decrementing retries to " + decrementedRetries + " for " + job);
            job.release();
            job.setRetries(decrementedRetries);
            job.setException(sw.toString());
            Transaction transaction = environment.get(Transaction.class);
            JobExecutor jobExecutor = environment.get(JobExecutor.class);
            if (transaction != null && jobExecutor != null) {
                log.trace("registering job executor notifier with " + transaction);
                transaction.registerSynchronization(new JobAddedNotification(jobExecutor));
            }
        }
        return null;
    }
}

