/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.jobexecutor.AcquireJobsCmd;
import org.jbpm.pvm.internal.jobexecutor.DispatcherThread;
import org.jbpm.pvm.internal.jobexecutor.GetNextDueDateCmd;
import org.jbpm.pvm.internal.jobexecutor.JobExecutorThreadPool;
import org.jbpm.pvm.internal.jobexecutor.JobHistoryEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutor
implements Serializable {
    private static final Log log = Log.getLog((String)JobExecutor.class.getName());
    private static final long serialVersionUID = 1L;
    CommandService commandService;
    String name = "JobExecutor-" + JobExecutor.getHostName();
    int nbrOfThreads = 3;
    int idleMillis = 5000;
    int idleMillisMax = 120000;
    int historySize = 200;
    int lockMillis = 1800000;
    Command<Collection<Long>> acquireJobsCommand;
    Command<Date> nextDueDateCommand;
    boolean isActive = false;
    JobExecutorThreadPool jobExecutorThreadPool;
    DispatcherThread dispatcherThread = null;
    BlockingQueue<Collection<Long>> jobDbidsQueue = null;
    List<JobHistoryEntry> history = new ArrayList<JobHistoryEntry>();

    public synchronized void start() {
        if (this.commandService == null) {
            throw new JbpmException("no command executor available in job executor");
        }
        if (!this.isActive) {
            this.acquireJobsCommand = new AcquireJobsCmd(this);
            this.nextDueDateCommand = new GetNextDueDateCmd(this);
            this.jobDbidsQueue = new ArrayBlockingQueue<Collection<Long>>(this.nbrOfThreads, true);
            this.isActive = true;
            log.trace("starting job executor threads for job executor '" + this.name + "'...");
            this.jobExecutorThreadPool = new JobExecutorThreadPool(this);
            this.jobExecutorThreadPool.start();
            log.trace("starting dispatcher thread for job executor '" + this.name + "'...");
            this.dispatcherThread = new DispatcherThread(this);
            this.dispatcherThread.start();
        } else {
            log.trace("ignoring start: job executor '" + this.name + "' is already started'");
        }
    }

    public synchronized void stop() {
        this.stop(false);
    }

    public synchronized void stop(boolean join) {
        log.debug("stopping job executor");
        if (this.isActive) {
            this.isActive = false;
            this.dispatcherThread.deactivate(true);
            this.waitTillQueueEmpty();
            this.jobExecutorThreadPool.deactivate(join);
        } else {
            log.trace("ignoring stop: job executor '" + this.name + "' not started");
        }
    }

    protected void waitTillQueueEmpty() {
        while (!this.jobDbidsQueue.isEmpty()) {
            log.trace("waiting for job-id-queue to become empty");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.trace("waiting for job-id-queue to become empty got interrupted");
            }
        }
    }

    public void jobWasAdded() {
        if (this.dispatcherThread != null && this.dispatcherThread.isActive()) {
            this.dispatcherThread.jobWasAdded();
        }
    }

    protected static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    protected BlockingQueue<Collection<Long>> getJobDbidsQueue() {
        return this.jobDbidsQueue;
    }

    public String getName() {
        return this.name;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getIdleMillis() {
        return this.idleMillis;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getIdleMillisMax() {
        return this.idleMillisMax;
    }

    public int getLockMillis() {
        return this.lockMillis;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    public CommandService getCommandExecutor() {
        return this.commandService;
    }

    public Command<Collection<Long>> getAcquireJobsCommand() {
        return this.acquireJobsCommand;
    }

    public Command<Date> getNextDueDateCommand() {
        return this.nextDueDateCommand;
    }

    public DispatcherThread getDispatcherThread() {
        return this.dispatcherThread;
    }

    public List<JobHistoryEntry> getHistory() {
        return this.history;
    }

    public void setCommandExecutor(CommandService commandService) {
        this.commandService = commandService;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNbrOfJobExecutorThreads(int nbrOfJobExecutorThreads) {
        this.nbrOfThreads = nbrOfJobExecutorThreads;
    }

    public void setIdleInterval(int idleInterval) {
        this.idleMillis = idleInterval;
    }

    public void setMaxIdleInterval(int maxIdleInterval) {
        this.idleMillisMax = maxIdleInterval;
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historySize = historyMaxSize;
    }

    public void setMaxLockTime(int maxLockTime) {
        this.lockMillis = maxLockTime;
    }
}

