/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.jobexecutor.JobExecutorThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutorThreadPool {
    private static final Log log = Log.getLog((String)JobExecutorThreadPool.class.getName());
    List<JobExecutorThread> jobExecutorThreads = new ArrayList<JobExecutorThread>();
    JobExecutor jobExecutor;

    public JobExecutorThreadPool(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public JobExecutorThread startThread() {
        String threadName = this.getNextThreadName();
        JobExecutorThread jobExecutorThread = new JobExecutorThread(threadName, this.jobExecutor);
        this.jobExecutorThreads.add(jobExecutorThread);
        log.trace("starting " + threadName);
        jobExecutorThread.start();
        return jobExecutorThread;
    }

    public JobExecutorThread stopThread() {
        JobExecutorThread thread = null;
        int lastIndex = this.jobExecutorThreads.size() - 1;
        if (lastIndex >= 0) {
            thread = this.jobExecutorThreads.remove(lastIndex);
            thread.deactivate();
        }
        return thread;
    }

    public void start() {
        for (int i = 0; i < this.jobExecutor.getNbrOfThreads(); ++i) {
            this.startThread();
        }
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean join) {
        for (JobExecutorThread jobExecutorThread : this.jobExecutorThreads) {
            jobExecutorThread.deactivate(join);
        }
    }

    protected String getNextThreadName() {
        return "JobExecutorThread" + this.jobExecutorThreads.size();
    }

    public List<JobExecutorThread> getJobExecutorThreads() {
        return this.jobExecutorThreads;
    }
}

