/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.pvm.internal.model.Activity;
import org.jbpm.pvm.internal.model.ActivityCoordinatesImpl;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.Continuation;
import org.jbpm.pvm.internal.model.ObjectReference;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.Transition;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.wire.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityImpl
extends CompositeElementImpl
implements Activity {
    private static final long serialVersionUID = 1L;
    protected ObjectReference<ActivityBehaviour> behaviourReference;
    protected List<TransitionImpl> outgoingTransitions = new ArrayList<TransitionImpl>();
    protected List<TransitionImpl> incomingTransitions = new ArrayList<TransitionImpl>();
    protected TransitionImpl defaultOutgoingTransition;
    protected ActivityImpl parentActivity;
    protected String type;
    protected Continuation continuation = Continuation.SYNCHRONOUS;
    protected ActivityCoordinatesImpl coordinates;
    protected transient Map<String, TransitionImpl> outgoingTransitionsMap = null;

    @Override
    public ActivityImpl addActivity(ActivityImpl activity) {
        activity.setParentActivity(this);
        super.addActivity(activity);
        return activity;
    }

    @Override
    public ActivityImpl findActivity(String activityName) {
        if (activityName == null ? this.name == null : activityName.equals(this.name)) {
            return this;
        }
        return super.findActivity(activityName);
    }

    public TransitionImpl createOutgoingTransition() {
        TransitionImpl transition = new TransitionImpl();
        transition.setProcessDefinition(this.processDefinition);
        this.addOutgoingTransition(transition);
        if (this.defaultOutgoingTransition == null) {
            this.defaultOutgoingTransition = transition;
        }
        return transition;
    }

    public Transition addOutgoingTransition(TransitionImpl transition) {
        if (!this.outgoingTransitions.contains(transition)) {
            transition.setSource(this);
            transition.setSourceIndex(this.outgoingTransitions.size());
            this.outgoingTransitions.add(transition);
            this.clearOutgoingTransitionsMap();
        }
        return transition;
    }

    public boolean removeOutgoingTransition(TransitionImpl transition) {
        if (transition != null) {
            boolean isRemoved = this.outgoingTransitions.remove(transition);
            if (isRemoved) {
                transition.setSource(null);
                this.clearOutgoingTransitionsMap();
            }
            return isRemoved;
        }
        return false;
    }

    @Override
    public TransitionImpl getOutgoingTransition(String transitionName) {
        return this.getOutgoingTransitionsMap() != null ? this.outgoingTransitionsMap.get(transitionName) : null;
    }

    @Override
    public TransitionImpl findOutgoingTransition(String transitionName) {
        TransitionImpl transition = this.getOutgoingTransition(transitionName);
        if (transition != null) {
            return transition;
        }
        if (this.parentActivity != null) {
            return this.parentActivity.findOutgoingTransition(transitionName);
        }
        return null;
    }

    public TransitionImpl findDefaultTransition() {
        if (this.defaultOutgoingTransition != null) {
            return this.defaultOutgoingTransition;
        }
        if (this.parentActivity != null) {
            return this.parentActivity.findDefaultTransition();
        }
        return null;
    }

    @Override
    public List<Transition> getOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    @Override
    public boolean hasOutgoingTransition(String transitionName) {
        return this.getOutgoingTransition(transitionName) != null;
    }

    @Override
    public boolean hasOutgoingTransitions() {
        return !this.outgoingTransitions.isEmpty();
    }

    public void setOutgoingTransitions(List<TransitionImpl> outgoingTransitions) {
        if (!this.outgoingTransitions.isEmpty()) {
            ArrayList<TransitionImpl> removedTransitions = new ArrayList<TransitionImpl>(outgoingTransitions);
            for (TransitionImpl removedTransition : removedTransitions) {
                this.removeOutgoingTransition(removedTransition);
            }
        }
        if (outgoingTransitions != null) {
            this.outgoingTransitions = new ArrayList<TransitionImpl>();
            for (TransitionImpl addedTransition : outgoingTransitions) {
                this.addOutgoingTransition(addedTransition);
            }
        } else {
            this.outgoingTransitions = new ArrayList<TransitionImpl>();
        }
        this.clearOutgoingTransitionsMap();
    }

    public Transition addIncomingTransition(TransitionImpl transition) {
        transition.setDestination(this);
        this.incomingTransitions.add(transition);
        return transition;
    }

    public boolean removeIncomingTransition(TransitionImpl transition) {
        if (transition != null && this.incomingTransitions.remove(transition)) {
            transition.setDestination(null);
            return true;
        }
        return false;
    }

    @Override
    public List<Transition> getIncomingTransitions() {
        return this.incomingTransitions;
    }

    @Override
    public boolean hasIncomingTransitions() {
        return !this.incomingTransitions.isEmpty();
    }

    public void setIncomingTransitions(List<TransitionImpl> incomingTransitions) {
        if (!this.incomingTransitions.isEmpty()) {
            for (TransitionImpl removedTransition : this.incomingTransitions) {
                removedTransition.setDestination(null);
            }
        }
        if (incomingTransitions != null) {
            this.incomingTransitions = new ArrayList<TransitionImpl>(incomingTransitions);
            for (TransitionImpl addedTransition : incomingTransitions) {
                addedTransition.setDestination(this);
            }
        } else {
            this.incomingTransitions = null;
        }
    }

    public void setBehaviour(ActivityBehaviour activityBehaviour) {
        this.behaviourReference = new ObjectReference<ActivityBehaviour>(activityBehaviour);
    }

    public void setBehaviour(Descriptor descriptor) {
        this.behaviourReference = new ObjectReference(descriptor);
    }

    public void setBehaviour(String expression) {
        this.behaviourReference = new ObjectReference(expression);
    }

    public ObjectReference<ActivityBehaviour> getBehaviourReference() {
        return this.behaviourReference;
    }

    public void setBehaviourReference(ObjectReference<ActivityBehaviour> behaviourReference) {
        this.behaviourReference = behaviourReference;
    }

    public ActivityBehaviour getBehaviour() {
        ActivityBehaviour behaviour;
        ActivityBehaviour activityBehaviour = behaviour = this.behaviourReference != null ? this.behaviourReference.get() : null;
        if (behaviour == null) {
            throw new JbpmException("no behaviour on " + this);
        }
        return behaviour;
    }

    @Override
    public Map<String, Transition> getOutgoingTransitionsMap() {
        if (this.outgoingTransitionsMap == null) {
            this.outgoingTransitionsMap = new HashMap<String, TransitionImpl>();
            for (TransitionImpl transition : this.outgoingTransitions) {
                if (this.outgoingTransitionsMap.containsKey(transition.getName())) continue;
                this.outgoingTransitionsMap.put(transition.getName(), transition);
            }
        }
        return this.outgoingTransitionsMap;
    }

    void clearOutgoingTransitionsMap() {
        this.outgoingTransitionsMap = null;
    }

    static Map<String, ActivityImpl> getActivitiesMap(List<ActivityImpl> activities) {
        HashMap<String, ActivityImpl> map = null;
        if (activities != null) {
            map = new HashMap<String, ActivityImpl>();
            for (ActivityImpl activity : activities) {
                if (map.containsKey(activity.getName())) continue;
                map.put(activity.getName(), activity);
            }
        }
        return map;
    }

    public String toString() {
        if (this.name != null) {
            return "activity(" + this.name + ")";
        }
        if (this.dbid != 0L) {
            return "activity(" + this.dbid + ")";
        }
        return "activity(" + System.identityHashCode(this) + ")";
    }

    public List<ObservableElementImpl> getParentChain() {
        ArrayList<ObservableElementImpl> chain = new ArrayList<ObservableElementImpl>();
        for (ObservableElementImpl processElement = this; processElement != null; processElement = ((ObservableElementImpl)processElement).getParent()) {
            chain.add(processElement);
        }
        return chain;
    }

    public boolean isAsync() {
        return this.continuation != Continuation.SYNCHRONOUS;
    }

    public boolean contains(ActivityImpl activity) {
        while (activity != null) {
            if (activity.getParent() == this) {
                return true;
            }
            activity = activity.getParentActivity();
        }
        return false;
    }

    @Override
    public ObservableElementImpl getParent() {
        return this.parentActivity != null ? this.parentActivity : this.processDefinition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public TransitionImpl getDefaultOutgoingTransition() {
        return this.defaultOutgoingTransition;
    }

    public void setDefaultOutgoingTransition(TransitionImpl defaultOutgoingTransition) {
        this.defaultOutgoingTransition = defaultOutgoingTransition;
    }

    @Override
    public ActivityImpl getParentActivity() {
        return this.parentActivity;
    }

    public void setParentActivity(ActivityImpl parentActivity) {
        this.parentActivity = parentActivity;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ActivityCoordinatesImpl getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(ActivityCoordinatesImpl coordinates) {
        this.coordinates = coordinates;
    }

    public Continuation getContinuation() {
        return this.continuation;
    }

    public void setContinuation(Continuation continuation) {
        this.continuation = continuation;
    }
}

