/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.pvm.internal.model.Activity;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.CompositeElement;
import org.jbpm.pvm.internal.model.ScopeElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeElementImpl
extends ScopeElementImpl
implements CompositeElement {
    private static final long serialVersionUID = 1L;
    protected List<ActivityImpl> activities;
    protected transient Map<String, ActivityImpl> activitiesMap;

    public ActivityImpl createActivity() {
        return this.createActivity(null);
    }

    public ActivityImpl createActivity(String activityName) {
        ActivityImpl activity = new ActivityImpl();
        activity.setName(activityName);
        this.addActivity(activity);
        return activity;
    }

    public Activity addActivity(ActivityImpl activity) {
        activity.setProcessDefinition(this.processDefinition);
        if (this.activities == null) {
            this.activities = new ArrayList<ActivityImpl>();
        }
        if (!this.activities.contains(activity)) {
            this.activities.add(activity);
        }
        this.activitiesMap = null;
        return activity;
    }

    public boolean removeActivity(ActivityImpl activity) {
        if (activity != null && this.activities != null) {
            boolean isRemoved = this.activities.remove(activity);
            if (isRemoved) {
                activity.setParentActivity(null);
                if (this.activities.isEmpty()) {
                    this.activities = null;
                }
                this.activitiesMap = null;
            }
            return isRemoved;
        }
        return false;
    }

    @Override
    public ActivityImpl getActivity(String activityName) {
        return this.getActivitiesMap() != null ? this.activitiesMap.get(activityName) : null;
    }

    @Override
    public boolean hasActivity(String activityName) {
        return this.getActivitiesMap() != null && this.activitiesMap.containsKey(activityName);
    }

    @Override
    public ActivityImpl findActivity(String activityName) {
        if (this.activities != null) {
            for (ActivityImpl n : this.activities) {
                ActivityImpl activity = n.findActivity(activityName);
                if (activity == null) continue;
                return activity;
            }
        }
        return null;
    }

    @Override
    public List<? extends Activity> getActivities() {
        return this.activities;
    }

    @Override
    public Map<String, Activity> getActivitiesMap() {
        if (this.activitiesMap == null) {
            this.activitiesMap = ActivityImpl.getActivitiesMap(this.activities);
        }
        return this.activitiesMap;
    }

    @Override
    public boolean hasActivities() {
        return this.activities != null && !this.activities.isEmpty();
    }
}

