/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.env.Transaction;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExceptionHandlerSynchronization;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ObjectReference;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.OpenProcessDefinition;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;
import org.jbpm.pvm.internal.model.op.MoveToChildActivity;
import org.jbpm.pvm.internal.wire.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Log log = Log.getLog((String)ExceptionHandlerImpl.class.getName());
    protected long dbid;
    protected int dbversion;
    protected String exceptionClassName;
    protected boolean isTransactional;
    protected boolean isRethrowMasked;
    protected List<ObjectReference<EventListener>> eventListenerReferences;
    protected String transitionName;
    protected String activityName;

    public ObjectReference<EventListener> createEventListenerReference(EventListener eventListener) {
        ObjectReference<EventListener> eventListenerReference = this.createEventListenerReference();
        eventListenerReference.set(eventListener);
        return eventListenerReference;
    }

    public ObjectReference<EventListener> createEventListenerReference(Descriptor descriptor) {
        ObjectReference<EventListener> eventListenerReference = this.createEventListenerReference();
        eventListenerReference.setDescriptor(descriptor);
        return eventListenerReference;
    }

    public ObjectReference<EventListener> createActivityReference(String expression) {
        ObjectReference<EventListener> eventListenerReference = this.createEventListenerReference();
        eventListenerReference.setExpression(expression);
        return eventListenerReference;
    }

    public ObjectReference<EventListener> createEventListenerReference() {
        if (this.eventListenerReferences == null) {
            this.eventListenerReferences = new ArrayList<ObjectReference<EventListener>>();
        }
        ObjectReference<EventListener> actionObjectReference = new ObjectReference<EventListener>();
        this.eventListenerReferences.add(actionObjectReference);
        return actionObjectReference;
    }

    public List<EventListener> getEventListeners() {
        if (this.eventListenerReferences == null) {
            return null;
        }
        ArrayList<EventListener> eventListeners = new ArrayList<EventListener>(this.eventListenerReferences.size());
        for (ObjectReference<EventListener> eventListenerReference : this.eventListenerReferences) {
            EventListener eventListener = eventListenerReference.get();
            eventListeners.add(eventListener);
        }
        return eventListeners;
    }

    public boolean matches(Exception exception) {
        return this.matches(exception.getClass());
    }

    public boolean matches(Class<?> exceptionClass) {
        if (exceptionClass == null) {
            return false;
        }
        if (this.exceptionClassName == null || exceptionClass.getName().equals(this.exceptionClassName)) {
            return true;
        }
        Class<?> superClass = exceptionClass.getSuperclass();
        if (superClass != null) {
            return this.matches(superClass);
        }
        return false;
    }

    public void handle(ExecutionImpl execution, Exception exception) {
        if (this.isTransactional) {
            Transaction transaction;
            Environment environment = Environment.getCurrent();
            Transaction transaction2 = transaction = environment != null ? environment.get(Transaction.class) : null;
            if (transaction != null) {
                log.trace("registering exception handler to " + transaction);
                CommandService commandService = environment.get(CommandService.class);
                if (commandService == null) {
                    throw new JbpmException("environment doesn't have a command service for registering transactional exception handler", (Throwable)exception);
                }
                ExceptionHandlerSynchronization exceptionHandlerSynchronization = new ExceptionHandlerSynchronization(this, execution, exception, commandService);
                exceptionHandlerSynchronization.register(transaction);
                log.trace("registering exception handler to " + transaction);
                throw new JbpmException("transaction exception handler registered handler after transaction completed.  make sure this transaction is rolled back", (Throwable)exception);
            }
            throw new JbpmException("no transaction present in the environment for transactional exception handler", (Throwable)exception);
        }
        this.executeHandler(execution, exception);
    }

    void executeHandler(ExecutionImpl execution, Exception exception) {
        ActivityImpl activity;
        if (this.eventListenerReferences != null) {
            for (ObjectReference<EventListener> eventListenerReference : this.eventListenerReferences) {
                EventListener eventListener = eventListenerReference.get();
                log.trace("executing " + eventListener + " for " + this);
                try {
                    eventListener.notify((EventListenerExecution)execution);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new JbpmException("couldn't execute " + eventListener, (Throwable)e);
                }
            }
        }
        if (this.transitionName != null) {
            TransitionImpl transition;
            activity = execution.getActivity();
            if (activity == null) {
                transition = execution.getTransition();
                log.trace("no current activity.  searching for transition from parent of " + transition);
                if (transition != null) {
                    OpenProcessDefinition processDefinition = transition.getProcessDefinition();
                    ObservableElementImpl transitionParent = transition.getParent();
                    if (transitionParent != null && !transitionParent.equals(processDefinition)) {
                        activity = (ActivityImpl)processDefinition.findActivity(transitionParent.getName());
                    }
                }
            }
            if (activity != null) {
                transition = activity.findOutgoingTransition(this.transitionName);
                if (transition != null) {
                    log.trace(this.toString() + " takes transition " + this.transitionName);
                    execution.setTransition(transition);
                    execution.performAtomicOperationSync(AtomicOperation.TRANSITION_END_ACTIVITY);
                } else {
                    log.info("WARNING: " + this.toString() + " couldn't find transition " + this.transitionName + " on " + activity);
                }
            } else {
                log.info("WARNING: " + this.toString() + " couldn't find current activity to take transition " + this.transitionName);
            }
        } else if (this.activityName != null) {
            ActivityImpl childActivity;
            activity = execution.getActivity();
            ActivityImpl activityImpl = childActivity = activity != null ? activity.getActivity(this.activityName) : null;
            if (childActivity != null) {
                log.trace(this.toString() + " takes transition " + this.transitionName);
                execution.performAtomicOperationSync(new MoveToChildActivity(childActivity));
            } else {
                log.info("WARNING: " + this.toString() + " couldn't find child activity " + this.activityName);
            }
        }
    }

    public static void rethrow(Exception exception, String prefixMessage) {
        log.trace("rethrowing " + exception);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new JbpmException(prefixMessage + ": " + exception.getMessage(), (Throwable)exception);
    }

    public String toString() {
        return this.exceptionClassName != null ? "exception-handler(" + this.exceptionClassName + ")" : "exception-handler";
    }

    public long getDbid() {
        return this.dbid;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void setTransactional(boolean isTransactional) {
        this.isTransactional = isTransactional;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public boolean isRethrowMasked() {
        return this.isRethrowMasked;
    }

    public void setRethrowMasked(boolean isRethrowMasked) {
        this.isRethrowMasked = isRethrowMasked;
    }

    public List<ObjectReference<EventListener>> getEventListenerReferences() {
        return this.eventListenerReferences;
    }

    public void setEventListenerReferences(List<ObjectReference<EventListener>> activityReferences) {
        this.eventListenerReferences = activityReferences;
    }
}

