/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import javax.transaction.Synchronization;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.env.Transaction;
import org.jbpm.pvm.internal.model.ExceptionHandlerImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerSynchronization
implements Synchronization,
Command<Object> {
    private final ExceptionHandlerImpl exceptionHandler;
    private static final long serialVersionUID = 1L;
    protected ExecutionImpl execution;
    protected Exception exception;
    protected CommandService commandService;

    public ExceptionHandlerSynchronization(ExceptionHandlerImpl exceptionHandler, ExecutionImpl execution, Exception exception, CommandService commandService) {
        this.exceptionHandler = exceptionHandler;
        this.execution = execution;
        this.exception = exception;
        this.commandService = commandService;
    }

    public void afterCompletion(int status) {
        if (status != 4) {
            ExceptionHandlerImpl.log.info("WARNING: no rollback after transactional exception handler. did you forget to rollback the transaction ?");
        }
        this.commandService.execute(this);
    }

    @Override
    public Object execute(Environment environment) {
        DbSession dbSession = environment.get(DbSession.class);
        if (dbSession == null) {
            throw new JbpmException("no " + DbSession.class.getName() + " available in the environment for reloading the execution");
        }
        this.execution = dbSession.get(ExecutionImpl.class, this.execution.getId());
        this.exceptionHandler.executeHandler(this.execution, this.exception);
        return null;
    }

    public void beforeCompletion() {
    }

    public void register(Transaction transaction) {
        transaction.registerSynchronization(this);
    }
}

