/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.job.Job;
import org.jbpm.api.job.Timer;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.api.task.Assignable;
import org.jbpm.api.task.AssignmentHandler;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.client.ClientProcessDefinition;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.env.ExecutionContext;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.ActivityEnd;
import org.jbpm.pvm.internal.history.events.ActivityStart;
import org.jbpm.pvm.internal.history.events.AutomaticEnd;
import org.jbpm.pvm.internal.history.events.DecisionEnd;
import org.jbpm.pvm.internal.history.events.ProcessInstanceCreate;
import org.jbpm.pvm.internal.history.events.ProcessInstanceEnd;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.model.Activity;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.EventImpl;
import org.jbpm.pvm.internal.model.EventListenerReference;
import org.jbpm.pvm.internal.model.ExceptionHandlerImpl;
import org.jbpm.pvm.internal.model.IdGenerator;
import org.jbpm.pvm.internal.model.ObservableElement;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.ProcessElementImpl;
import org.jbpm.pvm.internal.model.ScopeElementImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.model.Transition;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;
import org.jbpm.pvm.internal.model.op.MoveToChildActivity;
import org.jbpm.pvm.internal.model.op.Signal;
import org.jbpm.pvm.internal.script.ScriptManager;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.session.MessageSession;
import org.jbpm.pvm.internal.session.RepositorySession;
import org.jbpm.pvm.internal.session.TimerSession;
import org.jbpm.pvm.internal.task.AssignableDefinitionImpl;
import org.jbpm.pvm.internal.task.SwimlaneDefinitionImpl;
import org.jbpm.pvm.internal.task.SwimlaneImpl;
import org.jbpm.pvm.internal.type.Variable;
import org.jbpm.pvm.internal.util.EqualsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionImpl
extends ScopeInstanceImpl
implements ClientProcessInstance,
ActivityExecution,
EventListenerExecution,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)ExecutionImpl.class.getName());
    protected String name;
    protected String key;
    protected String id;
    protected Collection<ExecutionImpl> executions = new ArrayList<ExecutionImpl>();
    protected ExecutionImpl parent = null;
    protected ExecutionImpl processInstance;
    protected ExecutionImpl superProcessExecution;
    protected ExecutionImpl subProcessInstance;
    protected Map<String, SwimlaneImpl> swimlanes = new HashMap<String, SwimlaneImpl>();
    protected Long historyActivityInstanceDbid;
    protected Date historyActivityStart;
    protected int priority = 0;
    protected Map<String, Variable> systemVariables = new HashMap<String, Variable>();
    protected String processDefinitionId;
    protected String activityName;
    protected ProcessDefinitionImpl processDefinition;
    private ActivityImpl activity;
    protected TransitionImpl transition;
    protected EventImpl event;
    protected AtomicOperation eventCompletedOperation;
    protected int eventListenerIndex;
    protected ObservableElementImpl eventSource;
    protected transient Map<String, Execution> executionsMap = null;
    protected Queue<AtomicOperation> atomicOperations;
    protected Propagation propagation = null;

    public void initializeProcessInstance(ProcessDefinitionImpl processDefinition, String key) {
        this.setProcessDefinition(processDefinition);
        this.setActivity(processDefinition.getInitial());
        this.processInstance = this;
        this.state = "created";
        this.key = key;
        IdGenerator idGenerator = processDefinition.getIdGenerator();
        if (idGenerator != null) {
            this.id = idGenerator.createId(processDefinition, null, this);
        }
        HistoryEvent.fire(new ProcessInstanceCreate(), this);
    }

    @Override
    public void start() {
        if (!"created".equals(this.state)) {
            throw new JbpmException(this.toString() + " is already begun: " + this.state);
        }
        this.state = "active-root";
        ExecutionImpl scopedExecution = this.initializeScopes();
        this.fire("start", this.getProcessDefinition());
        if (this.getActivity() != null) {
            scopedExecution.performAtomicOperation(AtomicOperation.EXECUTE_ACTIVITY);
        }
    }

    protected ExecutionImpl initializeScopes() {
        LinkedList<ActivityImpl> enteredActivities = new LinkedList<ActivityImpl>();
        ActivityImpl initial = this.getProcessDefinition().getInitial();
        ExecutionImpl scopedExecution = null;
        if (initial != null) {
            enteredActivities.add(initial);
            for (ActivityImpl parentActivity = initial.getParentActivity(); parentActivity != null; parentActivity = parentActivity.getParentActivity()) {
                enteredActivities.addFirst(parentActivity);
            }
            scopedExecution = this;
            this.initializeVariables(this.getProcessDefinition(), this);
            this.initializeTimers(this.getProcessDefinition());
            for (ActivityImpl enteredActivity : enteredActivities) {
                if (!enteredActivity.isLocalScope()) continue;
                scopedExecution.setActivity(enteredActivity);
                scopedExecution = scopedExecution.createScope(enteredActivity);
            }
            scopedExecution.setActivity(initial);
        }
        return scopedExecution;
    }

    public ExecutionImpl createScope(ScopeElementImpl scope) {
        ExecutionImpl child = this.createExecution(scope.getName());
        this.setState("inactive-scope");
        child.setState("active-root");
        child.setActivity(this.getActivity());
        child.setTransition(this.getTransition());
        child.setPropagation(this.getPropagation());
        child.initializeVariables(scope, this);
        child.initializeTimers(scope);
        return child;
    }

    public ExecutionImpl destroyScope(CompositeElementImpl scope) {
        this.destroyTimers(scope);
        this.parent.setActivity(this.getActivity());
        this.parent.setTransition(this.getTransition());
        this.parent.setPropagation(this.getPropagation());
        ExecutionImpl parentsParent = this.parent.getParent();
        if (parentsParent != null && "inactive-concurrent-root".equals(parentsParent.getState())) {
            this.parent.setState("active-concurrent");
        } else {
            this.parent.setState("active-root");
        }
        ExecutionImpl parent = this.parent;
        this.end();
        return parent;
    }

    @Override
    protected void destroyTimers(CompositeElementImpl scope) {
        TimerSession timerSession = Environment.getFromCurrent(TimerSession.class, false);
        if (timerSession != null) {
            log.debug("destroying timers of " + this);
            List<Timer> timers = timerSession.findTimersByExecution((Execution)this);
            for (Timer timer : timers) {
                Job job;
                if (timer == (job = (Job)Environment.getFromCurrent(JobImpl.class, false))) continue;
                timerSession.cancel(timer);
            }
        }
    }

    public String toString() {
        if (this.getId() != null) {
            return "execution[" + this.id + "]";
        }
        if (this.parent == null) {
            return "process-instance";
        }
        return "execution";
    }

    @Override
    public void end() {
        this.end("ended");
    }

    @Override
    public void end(String state) {
        if (state == null) {
            throw new JbpmException("state is null");
        }
        if (state.equals("created") || state.equals("active-root") || state.equals("active-concurrent") || state.equals("inactive-concurrent-root") || state.equals("inactive-scope") || state.equals("inactive-join") || state.equals("suspended") || state.equals("async")) {
            throw new JbpmException("invalid end state: " + state);
        }
        if (log.isDebugEnabled()) {
            if (state == "ended") {
                log.debug(this.toString() + " ends");
            } else {
                log.debug(this.toString() + " ends with state " + state);
            }
        }
        ArrayList<ExecutionImpl> executionsToEnd = new ArrayList<ExecutionImpl>(this.executions);
        for (ExecutionImpl child : executionsToEnd) {
            child.end(state);
        }
        this.setState(state);
        this.propagation = Propagation.EXPLICIT;
        if (this.parent != null) {
            this.parent.removeExecution(this);
        } else {
            DbSession dbSession;
            HistoryEvent.fire(new ProcessInstanceEnd(), this);
            this.fire("end", this.getProcessDefinition());
            if (this.superProcessExecution != null) {
                log.trace(this.toString() + " signals super process execution");
                this.superProcessExecution.signal();
            }
            if ((dbSession = Environment.getFromCurrent(DbSession.class, false)) != null) {
                dbSession.deleteProcessInstance(this.id, false);
            }
        }
    }

    public void end(OpenExecution executionToEnd) {
        ((ExecutionImpl)executionToEnd).end();
    }

    public void end(OpenExecution executionToEnd, String state) {
        ((ExecutionImpl)executionToEnd).end(state);
    }

    @Override
    public void signal() {
        this.signal(null, (Map)null);
    }

    @Override
    public void signal(String signal) {
        this.signal(signal, (Map)null);
    }

    @Override
    public void signal(Map<String, ?> parameters) {
        this.signal(null, parameters);
    }

    @Override
    public void signal(String signal, Map<String, ?> parameters) {
        this.checkActive();
        if (this.getProcessDefinition().isSuspended()) {
            throw new JbpmException("process definition " + this.getProcessDefinition().getId() + " is suspended");
        }
        this.propagation = Propagation.EXPLICIT;
        if (this.getActivity() != null) {
            this.performAtomicOperation(new Signal(signal, parameters));
        } else if (this.transition != null) {
            this.performAtomicOperation(AtomicOperation.TRANSITION_START_ACTIVITY);
        } else {
            throw new JbpmException("execution is not in a activity or in a transition");
        }
    }

    @Override
    public void signal(Execution execution) {
        ((ExecutionImpl)execution).signal(null, (Map)null);
    }

    @Override
    public void signal(String signalName, Execution execution) {
        ((ExecutionImpl)execution).signal(signalName, (Map)null);
    }

    @Override
    public void signal(Map<String, ?> parameters, Execution execution) {
        ((ExecutionImpl)execution).signal(null, parameters);
    }

    @Override
    public void signal(String signalName, Map<String, ?> parameters, Execution execution) {
        ((ExecutionImpl)execution).signal(signalName, parameters);
    }

    public void takeDefaultTransition() {
        TransitionImpl defaultTransition = this.getActivity().getDefaultOutgoingTransition();
        if (defaultTransition == null) {
            throw new JbpmException("there is no default transition in " + this.getActivity());
        }
        this.take(defaultTransition);
    }

    public void take(String transitionName) {
        if (this.getActivity() == null) {
            throw new JbpmException(this.toString() + " is not positioned in activity");
        }
        TransitionImpl transition = this.findTransition(transitionName);
        if (transition == null) {
            throw new JbpmException("there is no transition " + transitionName + " in " + this.getActivity());
        }
        this.take(transition);
    }

    public void take(Transition transition) {
        this.checkActive();
        this.setPropagation(Propagation.EXPLICIT);
        this.setTransition((TransitionImpl)transition);
        this.fire("end", this.getActivity(), AtomicOperation.TRANSITION_END_ACTIVITY);
    }

    public void take(Transition transition, Execution execution) {
        ((ExecutionImpl)execution).take(transition);
    }

    public void execute(String activityName) {
        if (this.getActivity() == null) {
            throw new JbpmException("activity is null");
        }
        ActivityImpl nestedActivity = this.getActivity().getActivity(activityName);
        if (nestedActivity == null) {
            throw new JbpmException("activity " + activityName + " doesn't exist in " + this.getActivity());
        }
        this.execute(nestedActivity);
    }

    public void execute(Activity activity) {
        if (activity == null) {
            throw new JbpmException("activity is null");
        }
        this.checkActive();
        this.propagation = Propagation.EXPLICIT;
        this.performAtomicOperation(new MoveToChildActivity((ActivityImpl)activity));
    }

    public void waitForSignal() {
        this.propagation = Propagation.WAIT;
    }

    public void proceed() {
        this.checkActive();
        TransitionImpl defaultTransition = this.findDefaultTransition();
        if (defaultTransition != null) {
            this.take(defaultTransition);
        } else {
            ActivityImpl parentActivity = this.getActivity().getParentActivity();
            if (parentActivity != null) {
                this.performAtomicOperation(AtomicOperation.PROPAGATE_TO_PARENT);
            } else {
                this.end();
            }
        }
    }

    public void setActivity(Activity activity, Execution execution) {
        ((ExecutionImpl)execution).setActivity(activity);
    }

    public void setActivity(Activity activity) {
        this.setActivity((ActivityImpl)activity);
    }

    public void fire(String eventName, ObservableElement eventSource) {
        this.fire(eventName, (ObservableElementImpl)eventSource, null);
    }

    public void fire(String eventName, ObservableElementImpl observableElement, AtomicOperation eventCompletedOperation) {
        EventImpl event = ExecutionImpl.findEvent(observableElement, eventName);
        if (event != null) {
            this.setEvent(event);
            this.setEventSource(observableElement);
            this.setEventListenerIndex(0);
            this.setEventCompletedOperation(eventCompletedOperation);
            this.performAtomicOperation(AtomicOperation.EXECUTE_EVENT_LISTENER);
        } else if (eventCompletedOperation != null) {
            this.performAtomicOperationSync(eventCompletedOperation);
        }
    }

    public static EventImpl findEvent(ObservableElementImpl observableElement, String eventName) {
        if (observableElement == null) {
            return null;
        }
        EventImpl event = observableElement.getEvent(eventName);
        if (event != null) {
            return event;
        }
        return ExecutionImpl.findEvent(observableElement.getParent(), eventName);
    }

    public void moveTo(ActivityImpl destination) {
        this.setActivity(destination);
        this.transition = null;
    }

    public ExecutionImpl startActivity(ActivityImpl activity) {
        ExecutionImpl propagatingExecution = this;
        if (activity.isLocalScope()) {
            propagatingExecution = this.createScope(activity);
        }
        this.fire("start", activity);
        return propagatingExecution;
    }

    public ExecutionImpl endActivity(ActivityImpl activity) {
        ExecutionImpl propagatingExecution = this;
        this.fire("end", activity);
        if (activity.isLocalScope()) {
            propagatingExecution = this.destroyScope(activity);
        }
        return propagatingExecution;
    }

    public synchronized void performAtomicOperation(AtomicOperation operation) {
        if (operation.isAsync(this)) {
            this.sendContinuationMessage(operation);
        } else {
            this.performAtomicOperationSync(operation);
        }
    }

    public void sendContinuationMessage(AtomicOperation operation) {
        Environment environment = Environment.getCurrent();
        MessageSession messageSession = environment.get(MessageSession.class);
        if (messageSession == null) {
            throw new JbpmException("no message-session configured to send asynchronous continuation message");
        }
        MessageImpl<?> asyncMessage = operation.createAsyncMessage(this);
        this.setState("async");
        messageSession.send(asyncMessage);
    }

    public void performAtomicOperationSync(AtomicOperation operation) {
        block13: {
            block12: {
                Environment environment;
                ExecutionContext originalExecutionContext;
                block11: {
                    if (this.atomicOperations != null) break block12;
                    this.atomicOperations = new LinkedList<AtomicOperation>();
                    this.atomicOperations.offer(operation);
                    originalExecutionContext = null;
                    ExecutionContext executionContext = null;
                    environment = Environment.getCurrent();
                    if (environment != null) {
                        originalExecutionContext = (ExecutionContext)environment.getContext("execution");
                        if (originalExecutionContext != null && originalExecutionContext.getExecution() == this) {
                            originalExecutionContext = null;
                        } else {
                            executionContext = new ExecutionContext(this);
                            environment.setContext(executionContext);
                        }
                    }
                    try {
                        while (!this.atomicOperations.isEmpty()) {
                            AtomicOperation atomicOperation = this.atomicOperations.poll();
                            atomicOperation.perform(this);
                        }
                        this.atomicOperations = null;
                        if (executionContext == null) break block11;
                    }
                    catch (RuntimeException e) {
                        try {
                            throw e;
                        }
                        catch (Throwable throwable) {
                            this.atomicOperations = null;
                            if (executionContext != null) {
                                environment.removeContext(executionContext);
                            }
                            if (originalExecutionContext != null) {
                                environment.setContext(originalExecutionContext);
                            }
                            throw throwable;
                        }
                    }
                    environment.removeContext(executionContext);
                }
                if (originalExecutionContext != null) {
                    environment.setContext(originalExecutionContext);
                }
                break block13;
            }
            this.atomicOperations.offer(operation);
        }
    }

    public void handleException(ObservableElementImpl observableElement, EventImpl event, EventListenerReference eventListenerReference, Exception exception, String rethrowMessage) {
        ArrayList<ProcessElementImpl> processElements = new ArrayList<ProcessElementImpl>();
        if (eventListenerReference != null) {
            processElements.add(eventListenerReference);
        }
        if (event != null) {
            processElements.add(event);
        }
        while (observableElement != null) {
            processElements.add(observableElement);
            observableElement = observableElement.getParent();
        }
        block3: for (ProcessElementImpl processElement : processElements) {
            List<ExceptionHandlerImpl> exceptionHandlers = processElement.getExceptionHandlers();
            if (exceptionHandlers == null) continue;
            for (ExceptionHandlerImpl exceptionHandler : exceptionHandlers) {
                if (!exceptionHandler.matches(exception)) continue;
                try {
                    exceptionHandler.handle(this, exception);
                    return;
                }
                catch (Exception rethrowException) {
                    if (exceptionHandler.isRethrowMasked()) continue block3;
                    exception = rethrowException;
                    continue block3;
                }
            }
        }
        log.trace("rethrowing exception cause no exception handler for " + exception);
        ExceptionHandlerImpl.rethrow(exception, rethrowMessage + ": " + exception.getMessage());
    }

    public void initializeAssignments(AssignableDefinitionImpl assignableDefinition, Assignable assignable) {
        AssignmentHandler assignmentHandler;
        String candidateGroupsExpression;
        String candidateUsersExpression;
        String assigneeExpression = assignableDefinition.getAssigneeExpression();
        if (assigneeExpression != null) {
            String assignee = this.resolveAssignmentExpression(assigneeExpression, assignableDefinition.getAssigneeExpressionLanguage());
            assignable.setAssignee(assignee);
            if (log.isTraceEnabled()) {
                log.trace("task " + this.name + " assigned to " + assignee + " using expression " + assigneeExpression);
            }
        }
        if ((candidateUsersExpression = assignableDefinition.getCandidateUsersExpression()) != null) {
            String candidateUsers = this.resolveAssignmentExpression(candidateUsersExpression, assignableDefinition.getCandidateUsersExpressionLanguage());
            StringTokenizer tokenizer = new StringTokenizer(candidateUsers, ",");
            while (tokenizer.hasMoreTokens()) {
                String candidateUser = tokenizer.nextToken().trim();
                assignable.addCandidateUser(candidateUser);
            }
        }
        if ((candidateGroupsExpression = assignableDefinition.getCandidateGroupsExpression()) != null) {
            String candidateGroups = this.resolveAssignmentExpression(candidateGroupsExpression, assignableDefinition.getCandidateGroupsExpressionLanguage());
            StringTokenizer tokenizer = new StringTokenizer(candidateGroups, ",");
            while (tokenizer.hasMoreTokens()) {
                String candidateGroup = tokenizer.nextToken();
                assignable.addCandidateGroup(candidateGroup);
            }
        }
        if ((assignmentHandler = assignableDefinition.getAssignmentHandler()) != null) {
            try {
                assignmentHandler.assign(assignable, (OpenExecution)this);
            }
            catch (Exception e) {
                throw new JbpmException("assignment handler threw exception: " + e, (Throwable)e);
            }
        }
    }

    protected String resolveAssignmentExpression(String expression, String expressionLanguage) {
        ScriptManager scriptManager = Environment.getFromCurrent(ScriptManager.class);
        Object result = scriptManager.evaluateExpression(expression, expressionLanguage);
        if (result == null || result instanceof String) {
            return (String)result;
        }
        throw new JbpmException("result of assignment expression " + expression + " is " + result + " (" + result.getClass().getName() + ") instead of String");
    }

    public void addSwimlane(SwimlaneImpl swimlane) {
        this.swimlanes.put(swimlane.getName(), swimlane);
        swimlane.setExecution(this);
    }

    public SwimlaneImpl getSwimlane(String swimlaneName) {
        return this.swimlanes.get(swimlaneName);
    }

    public void removeSwimlane(SwimlaneImpl swimlane) {
        this.swimlanes.remove(swimlane.getName());
        swimlane.setExecution(null);
    }

    public SwimlaneImpl getInitializedSwimlane(SwimlaneDefinitionImpl swimlaneDefinition) {
        String swimlaneName = swimlaneDefinition.getName();
        SwimlaneImpl swimlane = this.swimlanes.get(swimlaneName);
        if (swimlane == null) {
            swimlane = this.createSwimlane(swimlaneName);
            this.initializeAssignments(swimlaneDefinition, swimlane);
        }
        return swimlane;
    }

    public SwimlaneImpl createSwimlane(String swimlaneName) {
        SwimlaneImpl swimlane = new SwimlaneImpl();
        swimlane.setName(swimlaneName);
        swimlane.setExecution(this);
        this.swimlanes.put(swimlaneName, swimlane);
        return swimlane;
    }

    public ExecutionImpl createExecution() {
        return this.createExecution(null);
    }

    public ExecutionImpl createExecution(String name) {
        this.propagation = Propagation.EXPLICIT;
        ExecutionImpl childExecution = this.newChildExecution();
        this.addExecution(childExecution);
        childExecution.setProcessDefinition(this.getProcessDefinition());
        childExecution.processInstance = this.processInstance;
        childExecution.name = name;
        IdGenerator keyGenerator = Environment.getFromCurrent(IdGenerator.class, false);
        if (keyGenerator != null) {
            childExecution.id = keyGenerator.createId(this.getProcessDefinition(), (Execution)this, childExecution);
        }
        log.debug("created " + childExecution);
        return childExecution;
    }

    protected ExecutionImpl newChildExecution() {
        return new ExecutionImpl();
    }

    public void addExecution(ExecutionImpl execution) {
        execution.setParent(this);
        this.executions.add(execution);
        this.executionsMap = null;
    }

    public ExecutionImpl getExecution(String name) {
        Map<String, Execution> executionsMap = this.getExecutionsMap();
        return (ExecutionImpl)(executionsMap != null ? executionsMap.get(name) : null);
    }

    public void removeExecution(ExecutionImpl child) {
        if (this.executions.contains(child)) {
            if (this.executions.remove(child)) {
                child.setParent(null);
                this.executionsMap = null;
            } else {
                throw new JbpmException(child + " is not a child execution of " + this);
            }
        }
    }

    public Map<String, Execution> getExecutionsMap() {
        if (this.executionsMap == null) {
            this.executionsMap = new HashMap<String, Execution>();
            for (ExecutionImpl execution : this.executions) {
                String executionName = execution.getName();
                if (this.executionsMap.containsKey(executionName)) continue;
                this.executionsMap.put(executionName, (Execution)execution);
            }
        }
        return this.executionsMap;
    }

    public boolean hasExecution(String name) {
        return this.getExecutionsMap() != null && this.executionsMap.containsKey(name);
    }

    public boolean isActive(String activityName) {
        return this.findActiveActivityNames().contains(activityName);
    }

    public Set<String> findActiveActivityNames() {
        return this.addActiveActivityNames(new HashSet<String>());
    }

    protected Set<String> addActiveActivityNames(Set<String> activityNames) {
        if ((this.state.equals("active-root") || this.state.equals("active-concurrent")) && this.activityName != null) {
            activityNames.add(this.activityName);
        }
        for (ExecutionImpl childExecution : this.executions) {
            childExecution.addActiveActivityNames(activityNames);
        }
        return activityNames;
    }

    public ExecutionImpl findActiveExecutionIn(String activityName) {
        if (activityName.equals(this.activityName) && this.isActive()) {
            return this;
        }
        for (ExecutionImpl childExecution : this.executions) {
            ExecutionImpl found = childExecution.findActiveExecutionIn(activityName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void createSystemVariable(String key, Object value) {
        this.createSystemVariable(key, value, null);
    }

    public void createSystemVariable(String key, Object value, String typeName) {
        Variable variable = this.createVariableObject(key, value, typeName, false);
        this.systemVariables.put(variable.getKey(), variable);
    }

    public void setSystemVariable(String key, Object value) {
        Variable variable = this.systemVariables.get(key);
        if (variable != null) {
            log.debug("setting system variable '" + key + "' in '" + this + "' to value '" + value + "'");
            variable.setValue(value);
        } else {
            log.debug("creating system variable '" + key + "' in '" + this + "' to value '" + value + "'");
            this.createSystemVariable(key, value, null);
        }
    }

    public Object getSystemVariable(String key) {
        Variable variable = this.systemVariables.get(key);
        if (variable != null) {
            return variable.getValue();
        }
        return null;
    }

    public boolean removeSystemVariable(String key) {
        if (this.systemVariables.containsKey(key)) {
            return this.systemVariables.remove(key) != null;
        }
        return false;
    }

    public ClientProcessInstance createSubProcessInstance(ClientProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    public ClientProcessInstance createSubProcessInstance(ClientProcessDefinition processDefinition, String key) {
        if (this.subProcessInstance != null) {
            throw new JbpmException(this.toString() + " already has a sub process instance: " + this.subProcessInstance);
        }
        this.subProcessInstance = (ExecutionImpl)processDefinition.createProcessInstance(key);
        this.subProcessInstance.setSuperProcessExecution(this);
        return this.subProcessInstance;
    }

    public ClientProcessInstance startSubProcessInstance(ClientProcessDefinition processDefinition) {
        return this.startSubProcessInstance(processDefinition, null);
    }

    public ClientProcessInstance startSubProcessInstance(ClientProcessDefinition processDefinition, String key) {
        this.createSubProcessInstance(processDefinition, key);
        this.subProcessInstance.start();
        return this.subProcessInstance;
    }

    @Override
    public void suspend() {
        super.suspend();
        this.propagation = Propagation.EXPLICIT;
        DbSession dbSession = Environment.getFromCurrent(DbSession.class, false);
        if (dbSession != null) {
            dbSession.cascadeExecutionSuspend(this);
        }
    }

    @Override
    public void resume() {
        super.resume();
        DbSession hibernatePvmDbSession = Environment.getFromCurrent(DbSession.class, false);
        if (hibernatePvmDbSession != null) {
            hibernatePvmDbSession.cascadeExecutionResume(this);
        }
    }

    protected void checkActive() {
        if (!this.isActive()) {
            throw new JbpmException(this.toString() + " is not active: " + this.state);
        }
    }

    public boolean isEnded() {
        if ("ended".equals(this.state)) {
            return true;
        }
        if ("created".equals(this.state)) {
            return false;
        }
        if ("active-root".equals(this.state)) {
            return false;
        }
        if ("active-concurrent".equals(this.state)) {
            return false;
        }
        if ("inactive-concurrent-root".equals(this.state)) {
            return false;
        }
        if ("inactive-scope".equals(this.state)) {
            return false;
        }
        if ("suspended".equals(this.state)) {
            return false;
        }
        return !"async".equals(this.state);
    }

    @Override
    public ScopeInstanceImpl getParentVariableScope() {
        return this.parent;
    }

    @Override
    public ExecutionImpl getTimerExecution() {
        return this;
    }

    protected TransitionImpl findTransition(String transitionName) {
        return this.getActivity().findOutgoingTransition(transitionName);
    }

    protected TransitionImpl findDefaultTransition() {
        return this.getActivity().findDefaultTransition();
    }

    public void historyAutomatic() {
        HistoryEvent.fire(new AutomaticEnd(), this);
    }

    public void historyDecision(String transitionName) {
        HistoryEvent.fire(new DecisionEnd(transitionName), this);
    }

    public void historyActivityStart() {
        HistoryEvent.fire(new ActivityStart(), this);
    }

    public void historyActivityEnd() {
        HistoryEvent.fire(new ActivityEnd(), this);
    }

    public void historyActivityEnd(String transitionName) {
        HistoryEvent.fire(new ActivityEnd(transitionName), this);
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public ProcessDefinitionImpl getProcessDefinition() {
        if (this.processDefinition == null && this.processDefinitionId != null) {
            RepositorySession repositorySession = Environment.getFromCurrent(RepositorySession.class);
            this.processDefinition = repositorySession.findProcessDefinitionById(this.processDefinitionId);
            if (this.processDefinition == null) {
                throw new JbpmException("couldn't find process definition " + this.processDefinitionId + " in the repository");
            }
        }
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
        this.processDefinitionId = processDefinition.getId();
    }

    public ActivityImpl getActivity() {
        if (this.activity == null && this.activityName != null) {
            this.activity = this.getProcessDefinition().findActivity(this.activityName);
        }
        return this.activity;
    }

    public void setActivity(ActivityImpl activity) {
        this.activity = activity;
        this.activityName = activity != null ? activity.getName() : null;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public boolean hasAsyncEndEvent(List<ActivityImpl> leftActivities) {
        for (ActivityImpl leftActivity : leftActivities) {
            EventImpl endEvent = leftActivity.getEvent("end");
            if (endEvent == null || !endEvent.isAsync()) continue;
            return true;
        }
        return false;
    }

    public boolean isProcessInstance() {
        return this.parent == null;
    }

    @Override
    public ExecutionImpl getExecution() {
        return this;
    }

    public TransitionImpl getTransition() {
        return this.transition;
    }

    public void setTransition(TransitionImpl transition) {
        this.transition = transition;
    }

    public EventImpl getEvent() {
        return this.event;
    }

    public ObservableElementImpl getEventSource() {
        return this.eventSource;
    }

    public Collection<ExecutionImpl> getExecutions() {
        return this.executions;
    }

    public String getName() {
        return this.name;
    }

    public ExecutionImpl getParent() {
        return this.parent;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setEvent(EventImpl event) {
        this.event = event;
    }

    public void setEventSource(ObservableElementImpl eventSource) {
        this.eventSource = eventSource;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ExecutionImpl getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ExecutionImpl processInstance) {
        this.processInstance = processInstance;
    }

    public String getKey() {
        return this.key;
    }

    public Propagation getPropagation() {
        return this.propagation;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExecutions(Collection<ExecutionImpl> executions) {
        this.executions = executions;
    }

    public void setParent(ExecutionImpl parent) {
        this.parent = parent;
    }

    public ExecutionImpl getSuperProcessExecution() {
        return this.superProcessExecution;
    }

    public void setSuperProcessExecution(ExecutionImpl superProcessExecution) {
        this.superProcessExecution = superProcessExecution;
    }

    public ExecutionImpl getSubProcessInstance() {
        return this.subProcessInstance;
    }

    public void setSubProcessInstance(ExecutionImpl subProcessExecution) {
        this.subProcessInstance = subProcessExecution;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getHistoryActivityInstanceDbid() {
        return this.historyActivityInstanceDbid;
    }

    public void setHistoryActivityInstanceDbid(Long historyActivityInstanceDbid) {
        this.historyActivityInstanceDbid = historyActivityInstanceDbid;
    }

    public Date getHistoryActivityStart() {
        return this.historyActivityStart;
    }

    public void setHistoryActivityStart(Date historyActivityStart) {
        this.historyActivityStart = historyActivityStart;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public int getEventListenerIndex() {
        return this.eventListenerIndex;
    }

    public void setEventListenerIndex(int eventListenerIndex) {
        this.eventListenerIndex = eventListenerIndex;
    }

    public AtomicOperation getEventCompletedOperation() {
        return this.eventCompletedOperation;
    }

    public void setEventCompletedOperation(AtomicOperation eventCompletedOperation) {
        this.eventCompletedOperation = eventCompletedOperation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Propagation {
        UNSPECIFIED,
        WAIT,
        EXPLICIT;

    }
}

