/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.model.ExceptionHandlerImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.WireProperties;
import org.jbpm.pvm.internal.wire.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessElementImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)ProcessElementImpl.class.getName());
    protected long dbid;
    protected int dbversion;
    protected ProcessDefinitionImpl processDefinition;
    protected List<ExceptionHandlerImpl> exceptionHandlers;
    protected WireProperties properties;

    public ExceptionHandlerImpl createExceptionHandler() {
        ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
        this.addExceptionHandler(exceptionHandler);
        return exceptionHandler;
    }

    public void addExceptionHandler(ExceptionHandlerImpl exceptionHandler) {
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new ArrayList<ExceptionHandlerImpl>();
        }
        this.exceptionHandlers.add(exceptionHandler);
    }

    public void addProperty(Descriptor descriptor) {
        if (this.properties == null) {
            this.properties = new WireProperties();
        }
        this.properties.add(descriptor);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public Set<String> getPropertyKeys() {
        if (this.properties == null) {
            return Collections.EMPTY_SET;
        }
        return this.properties.keys();
    }

    public long getDbid() {
        return this.dbid;
    }

    public ProcessDefinitionImpl getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
    }

    public WireProperties getProperties() {
        return this.properties;
    }

    public void setProperties(WireProperties properties) {
        this.properties = properties;
    }

    public List<ExceptionHandlerImpl> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void setExceptionHandlers(List<ExceptionHandlerImpl> exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }
}

