/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.util.List;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.Condition;
import org.jbpm.pvm.internal.model.EventImpl;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.Transition;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireContext;

public class TransitionImpl
extends ObservableElementImpl
implements Transition {
    private static final long serialVersionUID = 1L;
    protected ActivityImpl source;
    protected Integer sourceIndex;
    protected ActivityImpl destination;
    protected Descriptor conditionDescriptor;
    protected Descriptor waitConditionDescriptor;

    TransitionImpl() {
    }

    public void makeDefault() {
        this.source.setDefaultOutgoingTransition(this);
    }

    public String toString() {
        String destinationName = this.destination != null ? this.destination.getName() : null;
        String sourceName = this.source != null ? this.source.getName() : null;
        return (sourceName != null ? "(" + sourceName + ")--" : "--") + (this.name != null ? this.name + "-->" : ">") + (destinationName != null ? "(" + destinationName + ")" : "");
    }

    public EventImpl createEvent() {
        EventImpl event = new EventImpl();
        event.setName("take");
        this.addEvent(event);
        return event;
    }

    public EventImpl getEvent() {
        return this.getEvent("take");
    }

    public ObservableElementImpl getParent() {
        if (this.source == null || this.destination == null) {
            return this.processDefinition;
        }
        if (this.source.equals(this.destination)) {
            return this.source.getParent();
        }
        List<ObservableElementImpl> sourceChain = this.source.getParentChain();
        List<ObservableElementImpl> destinationChain = this.destination.getParentChain();
        for (ObservableElementImpl sourceElement : sourceChain) {
            for (ObservableElementImpl destinationElement : destinationChain) {
                if (!sourceElement.equals(destinationElement)) continue;
                return sourceElement;
            }
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
        if (this.source != null) {
            this.source.clearOutgoingTransitionsMap();
        }
    }

    public Condition getCondition() {
        if (this.conditionDescriptor == null) {
            return null;
        }
        return (Condition)WireContext.create(this.conditionDescriptor);
    }

    public Condition getWaitCondition() {
        if (this.waitConditionDescriptor == null) {
            return null;
        }
        return (Condition)WireContext.create(this.waitConditionDescriptor);
    }

    public ActivityImpl getSource() {
        return this.source;
    }

    public void setSource(ActivityImpl source) {
        this.source = source;
    }

    public ActivityImpl getDestination() {
        return this.destination;
    }

    public void setDestination(ActivityImpl destination) {
        this.destination = destination;
    }

    public Descriptor getConditionDescriptor() {
        return this.conditionDescriptor;
    }

    public void setConditionDescriptor(Descriptor conditionDescriptor) {
        this.conditionDescriptor = conditionDescriptor;
    }

    public Descriptor getWaitConditionDescriptor() {
        return this.waitConditionDescriptor;
    }

    public void setWaitConditionDescriptor(Descriptor waitConditionDescriptor) {
        this.waitConditionDescriptor = waitConditionDescriptor;
    }

    public Integer getSourceIndex() {
        return this.sourceIndex;
    }

    public void setSourceIndex(Integer sourceIndex) {
        this.sourceIndex = sourceIndex;
    }
}

