/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model.op;

import java.util.List;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.model.EventImpl;
import org.jbpm.pvm.internal.model.EventListenerReference;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;
import org.jbpm.pvm.internal.model.op.ExecuteEventListenerMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteEventListener
extends AtomicOperation {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog((String)ExecuteEventListener.class.getName());

    @Override
    public boolean isAsync(ExecutionImpl execution) {
        int eventListenerIndex = execution.getEventListenerIndex();
        EventImpl event = execution.getEvent();
        if (eventListenerIndex == 0 && event.isAsync()) {
            return true;
        }
        List<EventListenerReference> eventListenerReferences = event.getListenerReferences();
        if (eventListenerReferences == null || eventListenerReferences.isEmpty()) {
            return false;
        }
        EventListenerReference eventListenerReference = eventListenerReferences.get(eventListenerIndex);
        return eventListenerReference.isAsync();
    }

    @Override
    public void perform(ExecutionImpl execution) {
        EventImpl event = execution.getEvent();
        ObservableElementImpl observableElement = event.getObservableElement();
        int eventListenerIndex = execution.getEventListenerIndex();
        List<EventListenerReference> eventListenerReferences = event.getListenerReferences();
        if (eventListenerReferences != null && !eventListenerReferences.isEmpty()) {
            EventListenerReference eventListenerReference = eventListenerReferences.get(eventListenerIndex);
            ObservableElementImpl eventSource = execution.getEventSource();
            if (eventSource == observableElement || eventListenerReference.isPropagationEnabled()) {
                EventListener eventListener = (EventListener)eventListenerReference.get();
                log.trace("executing " + eventListener + " for " + event);
                try {
                    eventListener.notify((EventListenerExecution)execution);
                }
                catch (Exception e) {
                    log.trace("exception during action: " + e);
                    execution.handleException(observableElement, event, eventListenerReference, e, "couldn't run action " + eventListener);
                }
            }
            execution.setEventListenerIndex(++eventListenerIndex);
        }
        if (eventListenerReferences != null && eventListenerIndex < eventListenerReferences.size()) {
            execution.performAtomicOperation(AtomicOperation.EXECUTE_EVENT_LISTENER);
        } else {
            ObservableElementImpl parent = observableElement.getParent();
            EventImpl propagatedEvent = ExecutionImpl.findEvent(parent, event.getName());
            if (propagatedEvent != null) {
                execution.setEvent(propagatedEvent);
                execution.setEventListenerIndex(0);
                execution.performAtomicOperation(AtomicOperation.EXECUTE_EVENT_LISTENER);
            } else {
                AtomicOperation eventCompletedOperation = execution.getEventCompletedOperation();
                execution.setEvent(null);
                execution.setEventSource(null);
                execution.setEventListenerIndex(0);
                execution.setEventCompletedOperation(null);
                if (eventCompletedOperation != null) {
                    execution.performAtomicOperation(eventCompletedOperation);
                }
            }
        }
    }

    @Override
    public MessageImpl<?> createAsyncMessage(ExecutionImpl execution) {
        return new ExecuteEventListenerMessage(execution);
    }

    public String toString() {
        return "ExecuteEventListener";
    }
}

