/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model.op;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.EventImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteEventListenerMessage
extends MessageImpl<Object> {
    private static final String KEY_EVENT_COMPLETED_OPERATION = "ECO";
    private static final String KEY_EVENT_LISTENER_INDEX = "ELI";
    private static final String KEY_EVENT_NAME = "EN";
    private static final String KEY_EVENT_OBSERVABLE_PARENT_LEVEL = "EOPL";
    private static final String KEY_TRANSITION_SOURCE_INDEX = "TSI";
    private static final String KEY_TRANSITION_SOURCE = "TS";
    private static final String KEY_EVENT_SOURCE_TRANSITION = "EST";
    private static final String KEY_EVENT_SOURCE_ACTIVITY = "ESA";
    private static final String KEY_EVENT_SOURCE_PROCESS_DEFINITION = "ESPD";
    private static final String KEY_STATE = "S";
    private static final long serialVersionUID = 1L;

    public ExecuteEventListenerMessage() {
    }

    public ExecuteEventListenerMessage(ExecutionImpl execution) {
        super(execution);
        HashMap<String, Object> asyncExecutionInfo = new HashMap<String, Object>();
        TransitionImpl transition = execution.getTransition();
        if (transition != null) {
            ActivityImpl source = transition.getSource();
            asyncExecutionInfo.put(KEY_TRANSITION_SOURCE, source.getName());
            asyncExecutionInfo.put(KEY_TRANSITION_SOURCE_INDEX, source.getOutgoingTransitions().indexOf(transition));
        }
        asyncExecutionInfo.put(KEY_STATE, execution.getState());
        ObservableElementImpl eventSource = execution.getEventSource();
        if (eventSource instanceof ProcessDefinitionImpl) {
            asyncExecutionInfo.put(KEY_EVENT_SOURCE_PROCESS_DEFINITION, null);
        } else if (eventSource instanceof ActivityImpl) {
            asyncExecutionInfo.put(KEY_EVENT_SOURCE_ACTIVITY, eventSource.getName());
        } else if (eventSource instanceof TransitionImpl) {
            asyncExecutionInfo.put(KEY_EVENT_SOURCE_TRANSITION, null);
        }
        EventImpl event = execution.getEvent();
        asyncExecutionInfo.put(KEY_EVENT_OBSERVABLE_PARENT_LEVEL, this.getEventObservableParentLevel(eventSource, event.getObservableElement()));
        asyncExecutionInfo.put(KEY_EVENT_NAME, event.getName());
        asyncExecutionInfo.put(KEY_EVENT_LISTENER_INDEX, execution.getEventListenerIndex());
        AtomicOperation eventCompletedOperation = execution.getEventCompletedOperation();
        String eventCompletedOperationText = null;
        if (eventCompletedOperation != null) {
            eventCompletedOperationText = eventCompletedOperation.toString();
        }
        asyncExecutionInfo.put(KEY_EVENT_COMPLETED_OPERATION, eventCompletedOperationText);
        this.setConfiguration(asyncExecutionInfo);
    }

    public Integer getEventObservableParentLevel(ObservableElementImpl eventSource, ObservableElementImpl observableElement) {
        int parentLevel = 0;
        while (eventSource != observableElement) {
            ++parentLevel;
            eventSource = eventSource.getParent();
        }
        return parentLevel;
    }

    @Override
    public Object execute(Environment environment) throws Exception {
        ProcessDefinitionImpl processDefinition;
        Map asyncExecutionInfo = (Map)this.getConfiguration();
        String transitionSourceName = (String)asyncExecutionInfo.get(KEY_TRANSITION_SOURCE);
        TransitionImpl transition = null;
        if (transitionSourceName != null) {
            processDefinition = this.execution.getProcessDefinition();
            ActivityImpl transitionSource = processDefinition.findActivity(transitionSourceName);
            Integer transitionIndex = (Integer)asyncExecutionInfo.get(KEY_TRANSITION_SOURCE_INDEX);
            transition = (TransitionImpl)transitionSource.getOutgoingTransitions().get(transitionIndex);
            this.execution.setTransition(transition);
        }
        if (asyncExecutionInfo.containsKey(KEY_EVENT_SOURCE_PROCESS_DEFINITION)) {
            processDefinition = this.execution.getProcessDefinition();
            this.execution.setEventSource(processDefinition);
        } else if (asyncExecutionInfo.containsKey(KEY_EVENT_SOURCE_ACTIVITY)) {
            processDefinition = this.execution.getProcessDefinition();
            String activityName = (String)asyncExecutionInfo.get(KEY_EVENT_SOURCE_ACTIVITY);
            ActivityImpl activity = processDefinition.findActivity(activityName);
            this.execution.setEventSource(activity);
        } else if (asyncExecutionInfo.containsKey(KEY_EVENT_SOURCE_TRANSITION)) {
            this.execution.setEventSource(transition);
        }
        ObservableElementImpl observableElement = this.execution.getEventSource();
        int i = 0;
        for (int parentLevel = ((Integer)asyncExecutionInfo.get(KEY_EVENT_OBSERVABLE_PARENT_LEVEL)).intValue(); i < parentLevel; ++parentLevel) {
            observableElement = observableElement.getParent();
        }
        String eventName = (String)asyncExecutionInfo.get(KEY_EVENT_NAME);
        EventImpl event = observableElement.getEvent(eventName);
        this.execution.setEvent(event);
        Integer eventListenerIndex = (Integer)asyncExecutionInfo.get(KEY_EVENT_LISTENER_INDEX);
        this.execution.setEventListenerIndex(eventListenerIndex);
        String eventCompletedOperationText = (String)asyncExecutionInfo.get(KEY_EVENT_COMPLETED_OPERATION);
        AtomicOperation eventCompletedOperation = AtomicOperation.parseAtomicOperation(eventCompletedOperationText);
        this.execution.setEventCompletedOperation(eventCompletedOperation);
        this.execution.setState((String)asyncExecutionInfo.get(KEY_STATE));
        this.execution.performAtomicOperationSync(AtomicOperation.EXECUTE_EVENT_LISTENER);
        DbSession dbSession = environment.get(DbSession.class);
        dbSession.delete(this);
        return null;
    }
}

