/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.io.ObjectStreamException;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.query.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery
implements Command<Object> {
    private static final long serialVersionUID = 1L;
    protected CommandService commandService;
    protected String orderByClause = null;
    protected Page page = null;
    protected boolean isWhereAdded = false;

    protected abstract void applyParameters(Query var1);

    public abstract String hql();

    public List untypedList() {
        if (this.commandService != null) {
            return (List)this.commandService.execute(this);
        }
        Session session = Environment.getFromCurrent(Session.class);
        return (List)this.execute(session);
    }

    protected Object untypedUniqueResult() {
        List list = this.untypedList();
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new JbpmException("result not unique: " + list.size());
        }
        return list.get(0);
    }

    @Override
    public Object execute(Environment environment) throws Exception {
        Session session = environment.get(Session.class);
        return this.execute(session);
    }

    public Object execute(Session session) {
        String hql = this.hql();
        Query query = session.createQuery(hql);
        this.applyParameters(query);
        this.applyPage(query);
        return query.list();
    }

    protected void appendWhereClause(String whereClause, StringBuilder hql) {
        if (this.isWhereAdded) {
            hql.append("  and ");
        } else {
            this.isWhereAdded = true;
            hql.append("where ");
        }
        hql.append(whereClause);
    }

    protected void appendOrderByClause(StringBuilder hql) {
        if (this.orderByClause != null) {
            hql.append("order by ");
            hql.append(this.orderByClause);
        }
    }

    protected void applyPage(Query query) {
        if (this.page != null) {
            query.setFirstResult(this.page.firstResult);
            query.setMaxResults(this.page.maxResults);
        }
    }

    protected void addOrderByClause(String clause) {
        this.orderByClause = this.orderByClause == null ? clause : this.orderByClause + ", " + clause;
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.commandService = null;
        return this;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }
}

