/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.HashMap;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.history.model.HistoryActivityInstanceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceDistributionQueryCmd
implements Command<Object> {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String activityName;

    public ChoiceDistributionQueryCmd(String processDefinitionId, String activityName) {
        this.processDefinitionId = processDefinitionId;
        this.activityName = activityName;
    }

    @Override
    public Object execute(Environment environment) {
        Session session = environment.get(Session.class);
        Query query = session.createQuery("select hai.transitionName, count(hai) from " + HistoryActivityInstanceImpl.class.getName() + " as hai " + "where hai.historyProcessInstance.processDefinitionId = :processDefinitionId " + "  and hai.activityName = :activityName " + "group by hai.transitionName ");
        query.setString("processDefinitionId", this.processDefinitionId);
        query.setString("activityName", this.activityName);
        List transitionCounts = query.list();
        HashMap<String, Integer> choiceDistributionCounts = new HashMap<String, Integer>();
        for (Object[] pair : transitionCounts) {
            String transitionName = (String)pair[0];
            Number number = (Number)pair[1];
            choiceDistributionCounts.put(transitionName, new Integer(number.intValue()));
        }
        return choiceDistributionCounts;
    }
}

