/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Query;
import org.jbpm.api.JbpmException;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.identity.Group;
import org.jbpm.api.task.Task;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.identity.spi.IdentitySession;
import org.jbpm.pvm.internal.query.AbstractQuery;
import org.jbpm.pvm.internal.query.Page;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskQueryImpl
extends AbstractQuery
implements TaskQuery {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog((String)TaskQueryImpl.class.getName());
    protected boolean unassigned = false;
    protected String assignee = null;
    protected String candidate = null;
    protected Boolean suspended = null;
    protected String processInstanceId = null;
    protected String processDefinitionId = null;
    protected String activityName = null;
    protected List<String> groupIds;

    public TaskQuery assignee(String assignee) {
        if (this.candidate != null) {
            throw new JbpmException("assignee(...) cannot be combined with candidate(...) in one query");
        }
        this.assignee = assignee;
        return this;
    }

    public TaskQuery candidate(String userId) {
        this.candidate = userId;
        this.unassigned();
        return this;
    }

    public TaskQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public TaskQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public TaskQuery activityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    public TaskQuery unassigned() {
        this.assignee = null;
        this.unassigned = true;
        return this;
    }

    public TaskQuery suspended() {
        this.suspended = true;
        return this;
    }

    public TaskQuery notSuspended() {
        this.suspended = false;
        return this;
    }

    public TaskQuery orderAsc(String property) {
        this.orderByClause = "task." + property + " asc ";
        return this;
    }

    public TaskQuery orderDesc(String property) {
        this.orderByClause = "task." + property + " desc ";
        return this;
    }

    public TaskQuery page(int firstResult, int maxResults) {
        this.page = new Page(firstResult, maxResults);
        return this;
    }

    @Override
    protected void applyParameters(Query query) {
        if (this.assignee != null) {
            log.debug("setting parameter assignee: " + this.assignee);
            query.setString("assignee", this.assignee);
        }
        if (this.candidate != null) {
            log.debug("setting parameter candidateUserId: " + this.candidate);
            query.setString("candidateUserId", this.candidate);
            if (this.groupIds != null) {
                log.debug("setting parameter candidateGroupIds: " + this.groupIds);
                query.setParameterList("candidateGroupIds", this.groupIds);
            }
        }
    }

    @Override
    public String hql() {
        StringBuilder hql = new StringBuilder();
        hql.append("select task ");
        hql.append("from ");
        hql.append(TaskImpl.class.getName());
        hql.append(" as task ");
        if (this.candidate != null) {
            hql.append(", ");
            hql.append(ParticipationImpl.class.getName());
            hql.append(" as participant ");
            this.appendWhereClause("participant.task = task ", hql);
            this.appendWhereClause("participant.type = 'candidate' ", hql);
            IdentitySession identitySession = Environment.getFromCurrent(IdentitySession.class);
            List<Group> groups = identitySession.findGroupsByUser(this.candidate);
            if (groups.isEmpty()) {
                this.groupIds = null;
                this.appendWhereClause("participant.userId = :candidateUserId ", hql);
            } else {
                this.groupIds = new ArrayList<String>();
                for (Group group : groups) {
                    this.groupIds.add(group.getId());
                }
                this.appendWhereClause("((participant.userId = :candidateUserId) or (participant.groupId in (:candidateGroupIds)))", hql);
            }
        }
        if (this.suspended != null) {
            if (this.suspended.booleanValue()) {
                this.appendWhereClause("task.state = 'suspended' ", hql);
            } else {
                this.appendWhereClause("task.state != 'suspended' ", hql);
            }
        }
        if (this.processInstanceId != null) {
            this.appendWhereClause("task.processInstance.id = '" + this.processInstanceId + "' ", hql);
        }
        if (this.activityName != null) {
            this.appendWhereClause("task.execution.activityName = '" + this.activityName + "' ", hql);
        }
        if (this.processDefinitionId != null) {
            this.appendWhereClause("task.processInstance.processDefinitionId = '" + this.processDefinitionId + "' ", hql);
        }
        if (this.assignee != null) {
            this.appendWhereClause("task.assignee = :assignee ", hql);
        } else if (this.unassigned) {
            this.appendWhereClause("task.assignee is null ", hql);
        }
        this.appendOrderByClause(hql);
        String hqlQuery = hql.toString();
        log.debug(hqlQuery);
        return hqlQuery;
    }

    public List<Task> list() {
        return (List)this.commandService.execute(this);
    }

    public Task uniqueResult() {
        return (Task)this.untypedUniqueResult();
    }
}

