/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.repository.Deployer;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.RepositoryCache;
import org.jbpm.pvm.internal.xml.Problem;

public class DeployerManager {
    private static Log log = Log.getLog((String)DeployerManager.class.getName());
    List<Deployer> deployers;

    public void deploy(DeploymentImpl deployment) {
        deployment.setProblems(new ArrayList<Problem>());
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment);
        }
        if (deployment.hasErrors()) {
            JbpmException jbpmException = deployment.getJbpmException();
            log.info("errors during deployment of " + deployment + ": " + jbpmException.getMessage());
            throw jbpmException;
        }
        RepositoryCache repositoryCache = Environment.getFromCurrent(RepositoryCache.class);
        repositoryCache.set(deployment.getId(), deployment.getObjects());
    }
}

