/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.pvm.internal.repository.RepositoryCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCacheImpl
implements RepositoryCache {
    Map<String, Map<String, Object>> deployments = new HashMap<String, Map<String, Object>>();

    @Override
    public Object get(String deploymentId, String objectName) {
        Map<String, Object> deploymentObjects = this.deployments.get(deploymentId);
        if (deploymentObjects == null) {
            return null;
        }
        return deploymentObjects.get(objectName);
    }

    @Override
    public void set(String deploymentId, Map<String, Object> objects) {
        if (objects == null) {
            this.deployments.put(deploymentId, null);
        } else {
            Map<String, Object> deploymentObjects = this.deployments.get(deploymentId);
            if (deploymentObjects == null) {
                deploymentObjects = new HashMap<String, Object>();
                this.deployments.put(deploymentId, deploymentObjects);
            }
            for (String objectName : objects.keySet()) {
                Object object = objects.get(objectName);
                deploymentObjects.put(objectName, object);
            }
        }
    }

    @Override
    public void remove(String deploymentDbid) {
        if (this.deployments != null) {
            this.deployments.remove(deploymentDbid);
        }
    }

    @Override
    public void clear() {
        this.deployments = new HashMap<String, Map<String, Object>>();
    }
}

