/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.query.ProcessDefinitionQueryImpl;
import org.jbpm.pvm.internal.repository.DeployerManager;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.DeploymentProperty;
import org.jbpm.pvm.internal.repository.RepositoryCache;
import org.jbpm.pvm.internal.session.RepositorySession;

public class RepositorySessionImpl
implements RepositorySession {
    private static Log log = Log.getLog((String)RepositorySessionImpl.class.getName());
    protected Session session;
    protected RepositoryCache repositoryCache;
    protected DeployerManager deployerManager;

    public String deploy(NewDeployment deployment) {
        DeploymentImpl deploymentImpl = (DeploymentImpl)deployment;
        this.session.save((Object)deploymentImpl);
        this.deployerManager.deploy(deploymentImpl);
        return deploymentImpl.getId();
    }

    public void cascadeDeploymentSuspend(DeploymentImpl deployment) {
        Set<String> processDefinitionIds = deployment.getProcessDefinitionIds();
        if (!processDefinitionIds.isEmpty()) {
            Query query = this.session.createQuery("select execution from " + ExecutionImpl.class.getName() + " as execution " + "where execution.processDefinitionId in (:processDefinitionIds) " + "  and execution.state != '" + "suspended" + "'");
            query.setParameterList("processDefinitionIds", processDefinitionIds);
            List executions = query.list();
            for (ExecutionImpl execution : executions) {
                execution.suspend();
            }
        }
        this.repositoryCache.remove(deployment.getId());
    }

    public void cascadeDeploymentResume(DeploymentImpl deployment) {
        Set<String> processDefinitionIds = deployment.getProcessDefinitionIds();
        if (!processDefinitionIds.isEmpty()) {
            Query query = this.session.createQuery("select execution from " + ExecutionImpl.class.getName() + " as execution " + "where execution.processDefinitionId in (:processDefinitionIds) " + "  and execution.state = '" + "suspended" + "'");
            query.setParameterList("processDefinitionIds", processDefinitionIds);
            List executions = query.list();
            for (ExecutionImpl execution : executions) {
                execution.resume();
            }
        }
    }

    public DeploymentImpl getDeployment(String deploymentId) {
        return (DeploymentImpl)this.session.get(DeploymentImpl.class, (Serializable)Long.valueOf(Long.parseLong(deploymentId)));
    }

    public Object getObject(String deploymentId, String objectName) {
        Object object = this.repositoryCache.get(deploymentId, objectName);
        if (object != null) {
            log.trace("repository cache hit");
        } else {
            if (deploymentId == null) {
                throw new JbpmException("deploymentId is null");
            }
            log.trace("loading deployment " + deploymentId + " from db");
            DeploymentImpl deployment = (DeploymentImpl)this.session.load(DeploymentImpl.class, (Serializable)Long.valueOf(Long.parseLong(deploymentId)));
            this.deployerManager.deploy(deployment);
            object = this.repositoryCache.get(deploymentId, objectName);
            if (object == null) {
                throw new JbpmException("deployment " + deploymentId + " doesn't contain object " + objectName);
            }
        }
        return object;
    }

    public byte[] getBytes(String deploymentId, String resourceName) {
        DeploymentImpl deployment = this.getDeployment(deploymentId);
        if (deployment == null) {
            return null;
        }
        return deployment.getBytes(resourceName);
    }

    public ProcessDefinitionQueryImpl createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl();
    }

    public ProcessDefinitionImpl findProcessDefinitionByKey(String processDefinitionKey) {
        ProcessDefinition processDefinition = this.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).orderDesc("versionProperty.longValue").page(0, 1).uniqueResult();
        if (processDefinition != null) {
            return this.findProcessDefinitionById(processDefinition.getId());
        }
        return null;
    }

    public ProcessDefinitionImpl findProcessDefinitionById(String processDefinitionId) {
        DeploymentProperty deploymentProperty = this.findDeploymentPropertyByProcessDefinitionId(processDefinitionId);
        if (deploymentProperty != null) {
            String deploymentId = deploymentProperty.getDeployment().getId();
            String objectName = deploymentProperty.getObjectName();
            return (ProcessDefinitionImpl)this.getObject(deploymentId, objectName);
        }
        return null;
    }

    public DeploymentProperty findDeploymentPropertyByProcessDefinitionId(String processDefinitionId) {
        DeploymentProperty deploymentProperty = (DeploymentProperty)this.session.createQuery("select deploymentProperty from " + DeploymentProperty.class.getName() + " as deploymentProperty " + "where deploymentProperty.key = '" + "pdid" + "' " + "  and deploymentProperty.stringValue = '" + processDefinitionId + "' ").setMaxResults(1).uniqueResult();
        return deploymentProperty;
    }
}

