/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.script;

import de.odysseus.el.ExpressionFactoryImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.jbpm.pvm.internal.script.JuelScriptEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuelScriptEngineFactory
implements ScriptEngineFactory {
    private static List<String> names = new ArrayList<String>(1);
    private static List<String> extensions;
    private static List<String> mimeTypes;

    @Override
    public String getEngineName() {
        return "juel";
    }

    @Override
    public String getEngineVersion() {
        return ExpressionFactoryImpl.class.getPackage().getImplementationVersion();
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return "JSP 2.1 EL";
    }

    @Override
    public String getLanguageVersion() {
        return "2.1";
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String[] args) {
        throw new UnsupportedOperationException("getMethodCallSyntax");
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder statement = new StringBuilder();
        statement.append("out:print(\"");
        int len = toDisplay.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    statement.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    statement.append("\\\\");
                    continue block4;
                }
                default: {
                    statement.append(ch);
                }
            }
        }
        statement.append("\")");
        return statement.toString();
    }

    @Override
    public String getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getProgram(String[] statements) {
        StringBuilder program = new StringBuilder();
        if (statements.length != 0) {
            for (int i = 0; i < statements.length; ++i) {
                program.append("${");
                program.append(statements[i]);
                program.append("} ");
            }
        }
        return program.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new JuelScriptEngine(this);
    }

    static {
        names.add("juel");
        names = Collections.unmodifiableList(names);
        extensions = names;
        mimeTypes = new ArrayList<String>(0);
        mimeTypes = Collections.unmodifiableList(mimeTypes);
    }
}

