/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.script;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.script.EnvironmentBindings;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.xml.WireParser;

public class ScriptManager {
    private static Log log = Log.getLog((String)ScriptManager.class.getName());
    private static ScriptManager defaultScriptManager = null;
    protected String defaultExpressionLanguage;
    protected String defaultScriptLanguage;
    protected ScriptEngineManager scriptEngineManager;
    protected String[] readContextNames = null;
    protected String writeContextName;

    public static synchronized ScriptManager getDefaultScriptManager() {
        if (defaultScriptManager == null) {
            WireDefinition wireDefinition = (WireDefinition)new WireParser().createParse().setString("<objects>  <script-manager default-expression-language='juel'                  default-script-language='beanshell'>    <script-language name='juel' factory='org.jbpm.pvm.internal.script.JuelScriptEngineFactory' />  </script-manager></objects>").execute().getDocumentObject();
            WireContext wireContext = new WireContext(wireDefinition);
            defaultScriptManager = wireContext.get(ScriptManager.class);
        }
        return defaultScriptManager;
    }

    public Object evaluateExpression(String expression, String language) {
        return this.evaluate(expression, language != null ? language : this.defaultExpressionLanguage);
    }

    public Object evaluateScript(String script, String language) {
        return this.evaluate(script, language != null ? language : this.defaultScriptLanguage);
    }

    public Object evaluate(String script, String language) {
        if (script == null) {
            return null;
        }
        if (language == null) {
            throw new JbpmException("no language specified");
        }
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(language);
        if (scriptEngine == null) {
            throw new JbpmException("no scripting engine configured for language " + language);
        }
        if (log.isTraceEnabled()) {
            log.trace("evaluating " + language + " script " + script);
        }
        return this.evaluate(scriptEngine, script);
    }

    protected Object evaluate(ScriptEngine scriptEngine, String script) {
        EnvironmentBindings bindings = new EnvironmentBindings(this.readContextNames, this.writeContextName);
        scriptEngine.setBindings(bindings, 100);
        try {
            Object result = scriptEngine.eval(script);
            if (log.isTraceEnabled()) {
                log.trace("script evaluated to " + result);
            }
            return result;
        }
        catch (ScriptException e) {
            throw new JbpmException("script evaluation error: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getDefaultExpressionLanguage() {
        return this.defaultExpressionLanguage;
    }

    public String getDefaultScriptLanguage() {
        return this.defaultScriptLanguage;
    }
}

