/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.ProvidedAuthentication;
import org.jbpm.pvm.internal.env.WireObject;

public class AbstractServiceImpl {
    protected CommandService commandService;
    protected ThreadLocal<List<WireObject>> contextThreadLocal;

    public CommandService getCommandService() {
        return this.commandService;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public void setUserId(String userId) {
        this.addTxWireObject(new WireObject(new ProvidedAuthentication(userId)));
    }

    public void setConnection(Connection connection) {
        this.addTxWireObject(new WireObject(connection));
    }

    protected synchronized void addTxWireObject(WireObject wireObject) {
        List<WireObject> txWireObjects;
        if (this.contextThreadLocal == null) {
            this.contextThreadLocal = new ThreadLocal();
        }
        if ((txWireObjects = this.contextThreadLocal.get()) == null) {
            txWireObjects = new ArrayList<WireObject>();
            this.contextThreadLocal.set(txWireObjects);
        }
        txWireObjects.add(wireObject);
    }

    protected void addTxWireObjects(AbstractCommand cmd) {
        if (this.contextThreadLocal != null) {
            cmd.setTxWireObjects(this.contextThreadLocal.get());
            this.contextThreadLocal.set(null);
        }
    }
}

