/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.job.MessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncCommandMessage
extends MessageImpl<Object> {
    private static final long serialVersionUID = 1L;
    Command<?> command;
    String userId;

    public AsyncCommandMessage(Command<?> command) {
        this.command = command;
    }

    public AsyncCommandMessage(Command<?> command, String userId) {
        this.command = command;
        this.userId = userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Environment environment) throws Exception {
        this.execution.setState("active-root");
        if (this.userId != null) {
            environment.setUserId(this.userId);
        }
        try {
            CommandService commandService = environment.get(CommandService.class);
            commandService.execute(this.command);
        }
        finally {
            if (this.userId != null) {
                environment.setUserId(null);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "AsyncCommandMessage[" + this.dbid + "]";
    }
}

