/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.svc.AuthorizationSession;
import org.jbpm.pvm.internal.svc.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationInterceptor
extends Interceptor {
    @Override
    public <T> T execute(Command<T> command) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            throw new JbpmException("no environment for verifying authorization");
        }
        AuthorizationSession authorizationSession = environment.get(AuthorizationSession.class);
        if (authorizationSession == null) {
            throw new JbpmException("no AuthorizationSession in environment for verifying authorization");
        }
        authorizationSession.checkPermission(command, environment);
        return this.next.execute(command);
    }
}

