/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import org.hibernate.StaleStateException;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.svc.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryInterceptor
extends Interceptor {
    private static final Log log = Log.getLog((String)RetryInterceptor.class.getName());
    int retries = 3;
    long delay = 50L;
    long delayFactor = 4L;

    @Override
    public <T> T execute(Command<T> command) {
        int attempt = 1;
        long sleepTime = this.delay;
        while (attempt <= this.retries) {
            if (attempt > 1) {
                log.trace("retrying...");
            }
            try {
                return this.next.execute(command);
            }
            catch (StaleStateException e) {
                ++attempt;
                log.trace("optimistic locking failed: " + (Object)((Object)e));
                log.trace("waiting " + sleepTime + " millis");
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e1) {
                    log.trace("retry sleeping got interrupted");
                }
                sleepTime *= this.delayFactor;
            }
        }
        throw new JbpmException("gave up after " + attempt + " attempts");
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelayFactor() {
        return this.delayFactor;
    }

    public void setDelayFactor(long delayFactor) {
        this.delayFactor = delayFactor;
    }
}

