/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.tx.jta;

import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.svc.Interceptor;
import org.jbpm.pvm.internal.tx.jta.JtaStatusHelper;
import org.jbpm.pvm.internal.tx.jta.JtaTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtaTransactionInterceptor
extends Interceptor {
    private static Log log = Log.getLog((String)JtaTransactionInterceptor.class.getName());

    @Override
    public <T> T execute(Command<T> command) {
        JtaTransaction jtaTransaction = Environment.getFromCurrent(JtaTransaction.class);
        UserTransaction userTransaction = jtaTransaction.lookupJeeUserTransaction();
        int status = JtaTransaction.getUserTransactionStatus(userTransaction);
        if (status == 0) {
            return this.executeInExistingTx(command);
        }
        if (status != 6 && status != 3 && status != 4) {
            throw new JbpmException("invalid transaction state: " + JtaStatusHelper.toString(status));
        }
        return this.executeInNewTx(command, jtaTransaction, status);
    }

    protected <T> T executeInExistingTx(Command<T> command) {
        return this.next.execute(command);
    }

    protected <T> T executeInNewTx(Command<T> command, JtaTransaction jtaTransaction, int status) {
        Transaction suspendedTransaction = null;
        if (status == 3 || status == 4) {
            suspendedTransaction = jtaTransaction.suspend();
        }
        T returnValue = null;
        try {
            jtaTransaction.begin();
            returnValue = this.next.execute(command);
            jtaTransaction.commit();
        }
        catch (RuntimeException e) {
            jtaTransaction.rollback();
            throw e;
        }
        finally {
            if (suspendedTransaction != null) {
                jtaTransaction.resume(suspendedTransaction);
            }
        }
        return returnValue;
    }
}

