/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.ArgDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.operation.Operation;
import org.jbpm.pvm.internal.xml.Bindings;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class ObjectBinding
extends WireDescriptorBinding {
    public static final String TAG = "object";

    public ObjectBinding() {
        super(TAG);
    }

    public static boolean isObjectDescriptor(Element element) {
        if (XmlUtil.attribute(element, "class") != null) {
            return true;
        }
        if (XmlUtil.attribute(element, "factory") != null) {
            return true;
        }
        return XmlUtil.element(element, "factory") != null;
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        ObjectDescriptor descriptor = new ObjectDescriptor();
        Parser wireParser = parser;
        String className = XmlUtil.attribute(element, "class");
        String expr = XmlUtil.attribute(element, "expr");
        String factoryObjectName = XmlUtil.attribute(element, "factory");
        Element factoryElement = XmlUtil.element(element, "factory");
        if (className != null) {
            Element constructorElement;
            descriptor.setClassName(className);
            if (factoryObjectName != null) {
                parse.addProblem("attribute 'factory' is specified together with attribute 'class' in element 'object': " + XmlUtil.toString(element), element);
            }
            if (factoryElement != null) {
                parse.addProblem("element 'factory' is specified together with attribute 'class' in element 'object': " + XmlUtil.toString(element), element);
            }
            if ((constructorElement = XmlUtil.element(element, "constructor")) != null) {
                List<Element> argElements = XmlUtil.elements(constructorElement, "arg");
                List<ArgDescriptor> argDescriptors = wireParser.parseArgs(argElements, parse);
                descriptor.setArgDescriptors(argDescriptors);
                if (element.hasAttribute("method")) {
                    parse.addProblem("attributes 'class' and 'method' indicate static method and also a 'constructor' element is specified for element 'object': " + XmlUtil.toString(element), element);
                }
            }
        } else if (factoryObjectName != null) {
            descriptor.setFactoryObjectName(factoryObjectName);
            if (factoryElement != null) {
                parse.addProblem("element 'factory' is specified together with attribute 'factory' in element 'object': " + XmlUtil.toString(element), element);
            }
        } else if (factoryElement != null) {
            Element factoryDescriptorElement = XmlUtil.element(factoryElement);
            Descriptor factoryDescriptor = (Descriptor)parser.parseElement(factoryDescriptorElement, parse, "descriptor");
            descriptor.setFactoryDescriptor(factoryDescriptor);
        } else if (expr != null) {
            descriptor.setExpr(expr);
            String lang = XmlUtil.attribute(element, "lang");
            descriptor.setLang(lang);
        } else {
            parse.addProblem("element 'object' must have one of {attribute 'class', attribute 'expr', attribute 'factory' or element 'factory'}: " + XmlUtil.toString(element), element);
        }
        if (element.hasAttribute("method")) {
            descriptor.setMethodName(element.getAttribute("method"));
            List<Element> argElements = XmlUtil.elements(element, "arg");
            List<ArgDescriptor> argDescriptors = wireParser.parseArgs(argElements, parse);
            descriptor.setArgDescriptors(argDescriptors);
        } else if (factoryObjectName != null || factoryElement != null) {
            parse.addProblem("element 'object' with a element 'factory' or a attribute 'factory' must have a attribute 'method': " + XmlUtil.toString(element), element);
        }
        if (className == null && XmlUtil.element(element, "constructor") != null) {
            parse.addProblem("element 'object' with a 'constructor' element must have 'class' attribute: " + XmlUtil.toString(element), element);
        }
        ArrayList<Operation> operations = null;
        List<Element> elements = XmlUtil.elements(element);
        Set<String> operationTagNames = null;
        Bindings bindings = parser.getBindings();
        operationTagNames = bindings != null ? bindings.getTagNames("operation") : Collections.EMPTY_SET;
        for (Element childElement : elements) {
            if (!operationTagNames.contains(childElement.getTagName())) continue;
            Operation operation = (Operation)parser.parseElement(childElement, parse, "operation");
            if (operations == null) {
                operations = new ArrayList<Operation>();
            }
            operations.add(operation);
        }
        descriptor.setOperations(operations);
        Boolean isAutoWireEnabled = XmlUtil.attributeBoolean(element, "auto-wire", false, parse);
        if (isAutoWireEnabled != null) {
            descriptor.setAutoWireEnabled(isAutoWireEnabled);
        }
        return descriptor;
    }
}

