/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.descriptor;

import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireException;
import org.jbpm.pvm.internal.wire.descriptor.AbstractDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)EnvDescriptor.class.getName());
    protected String objectName;
    protected String typeName;
    protected Class<?> type;

    public EnvDescriptor() {
    }

    public EnvDescriptor(Class<?> type) {
        this.type = type;
    }

    @Override
    public Object construct(WireContext wireContext) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            throw new WireException("no environment to get object " + (this.objectName != null ? this.objectName : this.typeName));
        }
        if (this.objectName != null) {
            log.trace("looking up " + this.objectName + " by name in environment");
            return environment.get(this.objectName);
        }
        log.trace("looking up an object of type " + this.typeName + " in environment");
        if (this.type == null) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                this.type = classLoader.loadClass(this.typeName);
            }
            catch (Exception e) {
                throw new WireException("couldn't load class " + this.typeName, e);
            }
        }
        return environment.get(this.type);
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }
}

