/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.operation;

import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.Transaction;
import org.jbpm.pvm.internal.tx.StandardResource;
import org.jbpm.pvm.internal.tx.StandardTransaction;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireException;
import org.jbpm.pvm.internal.wire.operation.Operation;

public class EnlistOperation
implements Operation {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog((String)EnlistOperation.class.getName());
    String transactionName = null;

    public void apply(Object target, WireContext wireContext) {
        if (!(target instanceof StandardResource)) {
            throw new WireException("operation enlist can only be applied on objects that implement " + StandardResource.class.getName() + ": " + target + (target != null ? " (" + target.getClass().getName() + ")" : ""));
        }
        Object object = null;
        object = this.transactionName != null ? wireContext.get(this.transactionName) : wireContext.get(Transaction.class);
        if (object == null || !(object instanceof StandardTransaction)) {
            throw new WireException("couldn't find " + StandardTransaction.class.getName() + " " + (this.transactionName != null ? "'" + this.transactionName + "'" : "by type") + " to enlist resource " + target);
        }
        StandardTransaction standardTransaction = (StandardTransaction)object;
        log.trace("enlisting resource " + target + " with transaction");
        standardTransaction.enlistResource((StandardResource)target);
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }
}

