/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.operation;

import java.lang.reflect.Field;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireException;
import org.jbpm.pvm.internal.wire.operation.AbstractOperation;

public class FieldOperation
extends AbstractOperation {
    private static final long serialVersionUID = 1L;
    String fieldName = null;
    Descriptor descriptor = null;
    transient Field field = null;
    private static Log log = Log.getLog((String)FieldOperation.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Object target, WireContext wireContext) {
        if (target != null) {
            FieldOperation fieldOperation = this;
            synchronized (fieldOperation) {
                if (this.field == null) {
                    Class<?> clazz = target.getClass();
                    this.field = ReflectUtil.getField(clazz, this.fieldName);
                }
            }
            Object value = wireContext.create(this.descriptor, true);
            try {
                ReflectUtil.set(this.field, target, value);
            }
            catch (Exception e) {
                throw new WireException("couldn't set " + this.fieldName + " to " + value, e);
            }
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public synchronized void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public synchronized void setDescriptor(Descriptor valueDescriptor) {
        this.descriptor = valueDescriptor;
    }
}

