/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.xml;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ListIterator;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import org.jbpm.pvm.internal.stream.FileStreamInput;
import org.jbpm.pvm.internal.stream.InputStreamInput;
import org.jbpm.pvm.internal.stream.ResourceStreamInput;
import org.jbpm.pvm.internal.stream.StreamInput;
import org.jbpm.pvm.internal.stream.StringStreamInput;
import org.jbpm.pvm.internal.stream.UrlStreamInput;
import org.jbpm.pvm.internal.xml.Parser;
import org.jbpm.pvm.internal.xml.ProblemImpl;
import org.jbpm.pvm.internal.xml.ProblemList;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parse
extends ProblemList
implements ErrorHandler {
    private static final long serialVersionUID = 1L;
    protected Parser parser;
    protected ClassLoader classLoader;
    protected StreamInput streamInput;
    protected InputStream inputStream;
    protected InputSource inputSource;
    protected DocumentBuilder documentBuilder = null;
    protected Document document = null;
    protected Stack<Object> objectStack;
    protected Object documentObject;

    protected Parse(Parser parser) {
        this.parser = parser;
    }

    public Parse setInputStream(InputStream inputStream) {
        this.streamInput = new InputStreamInput(inputStream);
        return this;
    }

    public Parse setUrl(URL url) {
        this.streamInput = new UrlStreamInput(url);
        return this;
    }

    public Parse setFile(File file) {
        this.streamInput = new FileStreamInput(file);
        return this;
    }

    public Parse setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Parse setResource(String resource) {
        this.streamInput = new ResourceStreamInput(resource, this.classLoader);
        return this;
    }

    public Parse setString(String xmlString) {
        this.streamInput = new StringStreamInput(xmlString);
        return this;
    }

    public Parse setStreamSource(StreamInput streamInput) {
        this.streamInput = streamInput;
        return this;
    }

    public Parse setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
        return this;
    }

    public Parse setDocument(Document document) {
        this.document = document;
        return this;
    }

    public Parse setDocumentObject(Object object) {
        this.documentObject = object;
        return this;
    }

    protected InputSource getInputSource() {
        if (this.inputSource != null) {
            return this.inputSource;
        }
        if (this.streamInput != null) {
            this.inputStream = this.streamInput.openStream();
            return new InputSource(this.inputStream);
        }
        this.addProblem("no source specified to parse");
        return null;
    }

    public Parse execute() {
        this.parser.execute(this);
        return this;
    }

    @Override
    public void error(SAXParseException e) {
        this.addXmlValidationProblem(e, "xml validation error");
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.addXmlValidationProblem(e, "xml validation error");
    }

    @Override
    public void warning(SAXParseException e) {
        this.addXmlValidationProblem(e, "xml validation warning");
    }

    protected void addXmlValidationProblem(SAXParseException e, String type) {
        ProblemImpl problem = new ProblemImpl(e.getMessage(), e, type);
        problem.setLine(e.getLineNumber());
        problem.setColumn(e.getColumnNumber());
        this.addProblem(problem);
    }

    public Parse checkErrors(String description) {
        if (this.hasErrors()) {
            throw this.getJbpmException();
        }
        return this;
    }

    public Parse pushObject(Object object) {
        if (this.objectStack == null) {
            this.objectStack = new Stack();
        }
        this.objectStack.push(object);
        return this;
    }

    public Object popObject() {
        if (this.objectStack != null) {
            return this.objectStack.pop();
        }
        return null;
    }

    public Object peekObject() {
        if (this.objectStack != null) {
            return this.objectStack.peek();
        }
        return null;
    }

    public <T> T findObject(Class<T> clazz) {
        if (this.objectStack != null && !this.objectStack.isEmpty()) {
            ListIterator listIter = this.objectStack.listIterator(this.objectStack.size());
            while (listIter.hasPrevious()) {
                Object object = listIter.previous();
                if (!clazz.isInstance(object)) continue;
                return clazz.cast(object);
            }
        }
        return null;
    }

    public Object getDocumentObject() {
        return this.documentObject;
    }

    public Document getDocument() {
        return this.document;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

