/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.xml.Problem;
import org.jbpm.pvm.internal.xml.ProblemImpl;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemList
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String NEWLINE = System.getProperty("line.separator");
    protected List<ProblemImpl> problems;

    public void addProblem(String msg, Exception e, String severity, Element element) {
        ProblemImpl problem = new ProblemImpl(msg, e, severity);
        if (element != null) {
            Integer column;
            Integer line = (Integer)element.getUserData("line");
            if (line != null) {
                problem.setLine(line);
            }
            if ((column = (Integer)element.getUserData("column")) != null) {
                problem.setColumn(column);
            }
        }
        this.addProblem(problem);
    }

    public void addProblem(String msg) {
        this.addProblem(msg, null, "error", null);
    }

    public void addProblem(String msg, Exception e) {
        this.addProblem(msg, e, "error", null);
    }

    public void addProblem(String msg, Element element) {
        this.addProblem(msg, null, "error", element);
    }

    public void addProblem(String msg, Exception e, Element element) {
        this.addProblem(msg, e, "error", element);
    }

    public List<Problem> getProblems() {
        if (this.problems == null) {
            return Collections.emptyList();
        }
        return this.problems;
    }

    public void addProblem(ProblemImpl problem) {
        if (this.problems == null) {
            this.problems = new ArrayList<ProblemImpl>();
        }
        this.problems.add(problem);
    }

    public void addProblems(List<Problem> problems) {
        if (this.problems == null) {
            this.problems = new ArrayList<ProblemImpl>();
        }
        this.problems.addAll(problems);
    }

    public boolean hasProblems() {
        return this.problems != null && this.problems.size() > 0;
    }

    public boolean hasErrors() {
        if (this.problems == null) {
            return false;
        }
        for (ProblemImpl problem : this.problems) {
            if (!"error".equals(problem.getSeverity())) continue;
            return true;
        }
        return false;
    }

    public void setProblems(List<Problem> problems) {
        this.problems = problems;
    }

    public JbpmException getJbpmException() {
        return this.getJbpmException(null);
    }

    public JbpmException getJbpmException(String message) {
        if (!this.hasErrors()) {
            return null;
        }
        JbpmException cause = null;
        StringBuilder errorMsg = new StringBuilder();
        if (this.problems != null) {
            if (message != null) {
                errorMsg.append(message);
                errorMsg.append(": ");
            }
            for (Problem p : this.getProblems()) {
                errorMsg.append(NEWLINE);
                errorMsg.append("  ");
                errorMsg.append(p.toString());
                if (p.getCause() == null) continue;
                cause = new JbpmException(p.getCause());
            }
        }
        return new JbpmException(errorMsg.toString(), cause);
    }
}

