/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cfg;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.api.Configuration;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.HistoryService;
import org.jbpm.api.IdentityService;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ManagementService;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.TaskService;
import org.jbpm.api.cmd.Command;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.CheckDbCmd;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.Context;
import org.jbpm.pvm.internal.env.EnvironmentFactory;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.env.JbpmConfigurationParser;
import org.jbpm.pvm.internal.env.PvmEnvironment;
import org.jbpm.pvm.internal.env.UserProvidedEnvironmentObject;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.stream.FileStreamInput;
import org.jbpm.pvm.internal.stream.InputStreamInput;
import org.jbpm.pvm.internal.stream.ResourceStreamInput;
import org.jbpm.pvm.internal.stream.StreamInput;
import org.jbpm.pvm.internal.stream.StringStreamInput;
import org.jbpm.pvm.internal.stream.UrlStreamInput;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessEngineImpl
extends Configuration
implements Context,
ProcessEngine,
EnvironmentFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)ProcessEngineImpl.class.getName());
    public static final String JBPM_LIBRARY_VERSION = "4.2";
    protected transient String jndiName;
    protected transient boolean checkDb = true;
    protected transient boolean isConfigured = false;
    protected transient WireContext processEngineWireContext = new WireContext(new WireDefinition(), "process-engine", true);
    protected transient WireDefinition transactionWireDefinition = new WireDefinition();
    protected transient ThreadLocal<List<UserProvidedEnvironmentObject>> userProvidedEnvironmentObjectsThreadLocal = new ThreadLocal();
    protected transient ThreadLocal<String> authenticatedUserIdThreadLocal = new ThreadLocal();
    protected transient CommandService userCommandService = null;

    public ProcessEngineImpl() {
        super((Configuration)null);
    }

    public ProcessEngine buildProcessEngine() {
        InitialContext initialContext;
        if (!this.isConfigured) {
            this.setResource("jbpm.cfg.xml");
        }
        if (this.jndiName != null) {
            try {
                initialContext = new InitialContext();
                ProcessEngineImpl existing = (ProcessEngineImpl)initialContext.lookup(this.jndiName);
                if (existing != null) {
                    log.debug("found existing process engine under " + this.jndiName);
                    return existing;
                }
            }
            catch (NamingException e) {
                log.debug("jndi name " + this.jndiName + " is not bound");
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("created ProcessEngine " + System.identityHashCode(this));
            if (this.processEngineWireContext != null && this.processEngineWireContext.getWireDefinition() != null && this.processEngineWireContext.getWireDefinition().getDescriptorTypes() != null) {
                log.trace("  process-engine-context " + System.identityHashCode(this.processEngineWireContext));
                for (Class<?> descriptorType : this.processEngineWireContext.getWireDefinition().getDescriptorTypes()) {
                    log.trace("    " + descriptorType.getName());
                }
            }
            if (this.transactionWireDefinition != null && this.transactionWireDefinition.getDescriptorTypes() != null) {
                log.trace("  transaction-context:");
                for (Class<?> descriptorType : this.transactionWireDefinition.getDescriptorTypes()) {
                    log.trace("    " + descriptorType.getName());
                }
            }
        }
        this.processEngineWireContext.create();
        this.userCommandService = (CommandService)this.processEngineWireContext.get("txRequiredCommandService");
        if (this.jndiName != null) {
            try {
                log.debug("publishing jBPM ProcessEngine in jndi at " + this.jndiName);
                initialContext = new InitialContext();
                initialContext.bind(this.jndiName, (Object)this);
            }
            catch (NamingException e) {
                throw new JbpmException("JNDI binding problem", (Throwable)e);
            }
        }
        this.checkDb();
        return this;
    }

    protected void checkDb() {
        if (this.checkDb) {
            this.userCommandService.execute(new CheckDbCmd());
        }
    }

    public Configuration setHibernateSessionFactory(Object hibernateSessionFactory) {
        this.processEngineWireContext.getWireDefinition().addDescriptor(new ProvidedObjectDescriptor(hibernateSessionFactory, true));
        return this;
    }

    public Configuration setInputStream(InputStream inputStream) {
        this.parse(new InputStreamInput(inputStream));
        return this;
    }

    public Configuration setResource(String resource) {
        this.parse(new ResourceStreamInput(resource, this.getClassLoader()));
        return this;
    }

    public Configuration setUrl(URL url) {
        this.parse(new UrlStreamInput(url));
        return this;
    }

    public Configuration setFile(File file) {
        this.parse(new FileStreamInput(file));
        return this;
    }

    public Configuration setXmlString(String xmlString) {
        this.parse(new StringStreamInput(xmlString));
        return this;
    }

    public static EnvironmentFactory parseXmlString(String xmlString) {
        ProcessEngineImpl processEngineImpl = new ProcessEngineImpl();
        processEngineImpl.setXmlString(xmlString);
        return processEngineImpl;
    }

    protected void parse(StreamInput streamSource) {
        this.isConfigured = true;
        JbpmConfigurationParser.getInstance().createParse().contextStackPush(this).setStreamSource(streamSource).execute().checkErrors("jbpm configuration " + streamSource);
    }

    public ExecutionService getExecutionService() {
        return this.processEngineWireContext.get(ExecutionService.class);
    }

    public HistoryService getHistoryService() {
        return this.processEngineWireContext.get(HistoryService.class);
    }

    public ManagementService getManagementService() {
        return this.processEngineWireContext.get(ManagementService.class);
    }

    public TaskService getTaskService() {
        return this.processEngineWireContext.get(TaskService.class);
    }

    public IdentityService getIdentityService() {
        return this.processEngineWireContext.get(IdentityService.class);
    }

    public RepositoryService getRepositoryService() {
        return this.processEngineWireContext.get(RepositoryService.class);
    }

    @Override
    public EnvironmentImpl openEnvironment() {
        PvmEnvironment environment = new PvmEnvironment(this);
        if (log.isTraceEnabled()) {
            log.trace("opening " + environment);
        }
        this.installAuthenticatedUserId(environment);
        this.installProcessEngineContext(environment);
        this.installTransactionContext(environment);
        return environment;
    }

    protected void installAuthenticatedUserId(EnvironmentImpl environment) {
        String authenticatedUserId = this.authenticatedUserIdThreadLocal.get();
        if (authenticatedUserId != null) {
            environment.setAuthenticatedUserId(authenticatedUserId);
            this.authenticatedUserIdThreadLocal.set(null);
        }
    }

    protected void installTransactionContext(PvmEnvironment environment) {
        WireContext transactionContext = new WireContext(this.transactionWireDefinition, "transaction", true);
        environment.setContext(transactionContext);
        EnvironmentImpl.pushEnvironment(environment);
        try {
            transactionContext.create();
        }
        catch (RuntimeException e) {
            EnvironmentImpl.popEnvironment();
            throw e;
        }
    }

    protected void installProcessEngineContext(PvmEnvironment environment) {
        environment.setContext(this.processEngineWireContext);
    }

    @Override
    public void close() {
        JobExecutor jobExecutor = this.get(JobExecutor.class);
        if (jobExecutor != null) {
            jobExecutor.stop(true);
        }
        this.processEngineWireContext.fire("close", null);
    }

    @Override
    public Object get(String key) {
        return this.processEngineWireContext.get(key);
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.processEngineWireContext.get(type);
    }

    @Override
    public String getName() {
        return this.processEngineWireContext.getName();
    }

    @Override
    public boolean has(String key) {
        return this.processEngineWireContext.has(key);
    }

    @Override
    public Set<String> keys() {
        return this.processEngineWireContext.keys();
    }

    @Override
    public Object set(String key, Object value) {
        return this.processEngineWireContext.set(key, value);
    }

    public void addProcessEngineWireDefinition(WireDefinition wireDefinition) {
        this.processEngineWireContext.getWireDefinition().addWireDefinition(wireDefinition);
    }

    public void addTransactionWireDefinition(WireDefinition wireDefinition) {
        this.transactionWireDefinition.addWireDefinition(wireDefinition);
    }

    public void setTransactionWireDefinition(WireDefinition transactionWireDefinition) {
        this.transactionWireDefinition = transactionWireDefinition;
    }

    public WireContext getProcessEngineWireContext() {
        return this.processEngineWireContext;
    }

    public void setProcessEngineWireContext(WireContext processEngineWireContext) {
        this.processEngineWireContext = processEngineWireContext;
    }

    public WireDefinition getTransactionWireDefinition() {
        return this.transactionWireDefinition;
    }

    public ProcessEngine setAuthenticatedUserId(String authenticatedUserId) {
        this.authenticatedUserIdThreadLocal.set(authenticatedUserId);
        return this;
    }

    public ProcessEngine setHibernateSession(Object hibernateSession) {
        this.addUserProvidedEnvironmentObject(new UserProvidedEnvironmentObject(hibernateSession, null, true));
        return this;
    }

    public ProcessEngine setJdbcConnection(Connection jdbcConnection) {
        this.addUserProvidedEnvironmentObject(new UserProvidedEnvironmentObject(jdbcConnection, null, true));
        return this;
    }

    protected synchronized void addUserProvidedEnvironmentObject(UserProvidedEnvironmentObject userProvidedEnvironmentObject) {
        List<UserProvidedEnvironmentObject> environmentObjects = this.userProvidedEnvironmentObjectsThreadLocal.get();
        if (environmentObjects == null) {
            environmentObjects = new ArrayList<UserProvidedEnvironmentObject>();
            this.userProvidedEnvironmentObjectsThreadLocal.set(environmentObjects);
        }
        environmentObjects.add(userProvidedEnvironmentObject);
    }

    public <T> T execute(Command<T> command) {
        return this.userCommandService.execute(command);
    }

    public ProcessEngineImpl skipDbCheck() {
        this.checkDb = false;
        return this;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }
}

