/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.task.Participation;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.task.ParticipationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetParticipantsCmd
extends AbstractCommand<List<Participation>> {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String swimlaneId;

    public GetParticipantsCmd(String taskId, String swimlaneId) {
        if (taskId == null) {
            throw new JbpmException("taskId is null");
        }
        this.taskId = taskId;
        this.swimlaneId = swimlaneId;
    }

    public List<Participation> execute(Environment environment) throws Exception {
        StringBuilder hql = new StringBuilder();
        hql.append("select role from ");
        hql.append(ParticipationImpl.class.getName());
        hql.append(" as role where ");
        if (this.taskId != null) {
            hql.append(" role.task.dbid = " + this.taskId + " ");
        } else if (this.swimlaneId != null) {
            hql.append(" role.swimlane.dbid = " + this.swimlaneId + " ");
        } else {
            throw new JbpmException("no task nor swimlane specified");
        }
        Session session = (Session)environment.get(Session.class);
        Query query = session.createQuery(hql.toString());
        List participations = query.list();
        return participations;
    }
}

