/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.email.impl;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.identity.Group;
import org.jbpm.api.identity.User;
import org.jbpm.pvm.internal.email.impl.AddressTemplate;
import org.jbpm.pvm.internal.email.impl.AttachmentTemplate;
import org.jbpm.pvm.internal.email.impl.MailTemplate;
import org.jbpm.pvm.internal.email.spi.AddressResolver;
import org.jbpm.pvm.internal.email.spi.MailProducer;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.identity.spi.IdentitySession;
import org.jbpm.pvm.internal.script.ScriptManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailProducerImpl
implements MailProducer,
Serializable {
    private static final long serialVersionUID = 1L;
    private MailTemplate template;

    public MailTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(MailTemplate template) {
        this.template = template;
    }

    @Override
    public Collection<Message> produce(Execution execution) {
        Message email = this.instantiateEmail();
        this.fillFrom(execution, email);
        this.fillRecipients(execution, email);
        this.fillSubject(execution, email);
        this.fillContent(execution, email);
        return Collections.singleton(email);
    }

    protected Message instantiateEmail() {
        return new MimeMessage((Session)null);
    }

    protected void fillFrom(Execution execution, Message email) {
        String groupList;
        AddressTemplate fromTemplate = this.template.getFrom();
        if (fromTemplate == null) {
            return;
        }
        String addresses = fromTemplate.getAddresses();
        if (addresses != null) {
            addresses = this.evaluateExpression(addresses, execution);
            try {
                email.addFrom((Address[])InternetAddress.parse((String)addresses));
            }
            catch (MessagingException e) {
                throw new JbpmException("failed to add " + addresses + " to senders", (Throwable)e);
            }
        }
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        IdentitySession identitySession = environment.get(IdentitySession.class);
        AddressResolver addressResolver = environment.get(AddressResolver.class);
        String userList = fromTemplate.getUsers();
        if (userList != null) {
            String[] userIds = this.tokenizeActors(userList, execution);
            List<User> users = identitySession.findUsersById(userIds);
            this.addSenders(this.resolveAddresses(users, addressResolver), email);
        }
        if ((groupList = fromTemplate.getGroups()) != null) {
            for (String groupId : this.tokenizeActors(groupList, execution)) {
                Group group = identitySession.findGroupById(groupId);
                this.addSenders(addressResolver.resolveAddresses(group), email);
            }
        }
    }

    private String evaluateExpression(String expression, Execution execution) {
        ScriptManager scriptManager = EnvironmentImpl.getFromCurrent(ScriptManager.class);
        Object value = scriptManager.evaluateExpression(expression, this.template.getLanguage());
        if (!(value instanceof String)) {
            throw new JbpmException("expected expression '" + expression + "' to return string, but was: " + value);
        }
        return (String)value;
    }

    private String[] tokenizeActors(String recipients, Execution execution) {
        String[] actors = this.evaluateExpression(recipients, execution).split("[,;|\\s]+");
        if (actors.length == 0) {
            throw new JbpmException("recipient list is empty: " + recipients);
        }
        return actors;
    }

    private Address[] resolveAddresses(List<User> users, AddressResolver addressResolver) {
        int userCount = users.size();
        Address[] addresses = new Address[userCount];
        for (int i = 0; i < userCount; ++i) {
            addresses[i] = addressResolver.resolveAddress(users.get(i));
        }
        return addresses;
    }

    private void addSenders(Address[] addresses, Message email) {
        try {
            email.addFrom(addresses);
        }
        catch (MessagingException e) {
            throw new JbpmException("failed to add " + Arrays.toString(addresses) + " to senders", (Throwable)e);
        }
    }

    protected void fillRecipients(Execution execution, Message email) {
        AddressTemplate bcc;
        AddressTemplate cc;
        AddressTemplate to = this.template.getTo();
        if (to != null) {
            this.fillRecipients(to, execution, email, Message.RecipientType.TO);
        }
        if ((cc = this.template.getCc()) != null) {
            this.fillRecipients(cc, execution, email, Message.RecipientType.CC);
        }
        if ((bcc = this.template.getBcc()) != null) {
            this.fillRecipients(bcc, execution, email, Message.RecipientType.BCC);
        }
    }

    private void fillRecipients(AddressTemplate addressTemplate, Execution execution, Message email, Message.RecipientType recipientType) {
        String groupList;
        String addresses = addressTemplate.getAddresses();
        if (addresses != null) {
            addresses = this.evaluateExpression(addresses, execution);
            try {
                email.addRecipients(recipientType, (Address[])InternetAddress.parse((String)addresses));
            }
            catch (MessagingException e) {
                throw new JbpmException("failed to add " + addresses + " to recipients of type " + recipientType, (Throwable)e);
            }
        }
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        IdentitySession identitySession = environment.get(IdentitySession.class);
        AddressResolver addressResolver = environment.get(AddressResolver.class);
        String userList = addressTemplate.getUsers();
        if (userList != null) {
            String[] userIds = this.tokenizeActors(userList, execution);
            List<User> users = identitySession.findUsersById(userIds);
            this.addRecipients(this.resolveAddresses(users, addressResolver), email, recipientType);
        }
        if ((groupList = addressTemplate.getGroups()) != null) {
            for (String groupId : this.tokenizeActors(groupList, execution)) {
                Group group = identitySession.findGroupById(groupId);
                this.addRecipients(addressResolver.resolveAddresses(group), email, recipientType);
            }
        }
    }

    private void addRecipients(Address[] addresses, Message email, Message.RecipientType recipientType) {
        try {
            email.addRecipients(recipientType, addresses);
        }
        catch (MessagingException e) {
            throw new JbpmException("failed to add " + Arrays.toString(addresses) + " to recipients of type " + recipientType, (Throwable)e);
        }
    }

    protected void fillSubject(Execution execution, Message email) {
        String subject = this.template.getSubject();
        if (subject != null) {
            subject = this.evaluateExpression(subject, execution);
            try {
                email.setSubject(subject);
            }
            catch (MessagingException e) {
                throw new JbpmException("failed to set subject to " + subject, (Throwable)e);
            }
        }
    }

    protected void fillContent(Execution execution, Message email) {
        String text = this.template.getText();
        String html = this.template.getHtml();
        List<AttachmentTemplate> attachmentTemplates = this.template.getAttachmentTemplates();
        if (html != null || !attachmentTemplates.isEmpty()) {
            MimeMultipart multipart = new MimeMultipart("related");
            if (text != null) {
                MimeBodyPart textPart = new MimeBodyPart();
                text = this.evaluateExpression(text, execution);
                try {
                    textPart.setText(text);
                    multipart.addBodyPart((BodyPart)textPart);
                }
                catch (MessagingException e) {
                    throw new JbpmException("failed to add text content: " + text, (Throwable)e);
                }
            }
            if (html != null) {
                MimeBodyPart htmlPart = new MimeBodyPart();
                html = this.evaluateExpression(html, execution);
                try {
                    htmlPart.setContent((Object)html, "text/html");
                    multipart.addBodyPart((BodyPart)htmlPart);
                }
                catch (MessagingException e) {
                    throw new JbpmException("failed to add html content: " + html, (Throwable)e);
                }
            }
            if (!attachmentTemplates.isEmpty()) {
                this.addAttachments(execution, (Multipart)multipart);
            }
            try {
                email.setContent((Multipart)multipart);
            }
            catch (MessagingException e) {
                throw new JbpmException("failed to set multipart content: " + multipart, (Throwable)e);
            }
        }
        if (text != null) {
            text = this.evaluateExpression(text, execution);
            try {
                email.setText(text);
            }
            catch (MessagingException e) {
                throw new JbpmException("failed to add text content: " + text, (Throwable)e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void addAttachments(Execution execution, Multipart multipart) {
        for (AttachmentTemplate attachmentTemplate : this.template.getAttachmentTemplates()) {
            attachmentPart = new MimeBodyPart();
            description = attachmentTemplate.getDescription();
            if (description != null) {
                description = this.evaluateExpression(description, execution);
                try {
                    attachmentPart.setDescription(description);
                }
                catch (MessagingException e) {
                    throw new JbpmException("failed to set attachment description: " + description, (Throwable)e);
                }
            }
            if ((name = attachmentTemplate.getName()) != null) {
                name = this.evaluateExpression(name, execution);
            }
            if ((file = attachmentTemplate.getFile()) != null) {
                targetFile = new File(this.evaluateExpression(file, execution));
                if (!targetFile.isFile()) {
                    throw new JbpmException("could not read attachment content, file not found: " + targetFile);
                }
                try {
                    attachmentPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(targetFile)));
                    if (name != null) ** GOTO lbl43
                    name = targetFile.getName();
                }
                catch (MessagingException e) {
                    throw new JbpmException("failed to add attachment content: " + targetFile, (Throwable)e);
                }
            } else {
                url = attachmentTemplate.getUrl();
                if (url != null) {
                    try {
                        url = this.evaluateExpression(url, execution);
                        targetUrl = new URL(url);
                    }
                    catch (MalformedURLException e) {
                        throw new JbpmException("could not read attachment content, malformed url: " + url, (Throwable)e);
                    }
                } else {
                    resource = this.evaluateExpression(attachmentTemplate.getResource(), execution);
                    targetUrl = EnvironmentImpl.getCurrent().getClassLoader().getResource(resource);
                    if (targetUrl == null) {
                        throw new JbpmException("could not read attachment content, resource not found: " + resource);
                    }
                }
                try {
                    attachmentPart.setDataHandler(new DataHandler(targetUrl));
                    if (name == null) {
                        name = MailProducerImpl.extractResourceName(targetUrl);
                    }
                }
                catch (MessagingException e) {
                    throw new JbpmException("failed to add attachment content: " + targetUrl, (Throwable)e);
                }
            }
lbl43:
            // 3 sources

            try {
                attachmentPart.setFileName(name);
            }
            catch (MessagingException e) {
                throw new JbpmException("failed to set attachment name: " + name, (Throwable)e);
            }
            try {
                multipart.addBodyPart((BodyPart)attachmentPart);
            }
            catch (MessagingException e) {
                throw new JbpmException("failed to add attachment part: " + attachmentPart, (Throwable)e);
            }
        }
    }

    private static String extractResourceName(URL url) {
        String path = url.getPath();
        if (path == null || path.length() == 0) {
            return null;
        }
        int sepIndex = path.lastIndexOf(47);
        return sepIndex != -1 ? path.substring(sepIndex) : null;
    }
}

