/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.env;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.Context;
import org.jbpm.pvm.internal.env.EnvironmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEnvironment
extends EnvironmentImpl {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)BasicEnvironment.class.getName());
    protected String authenticatedUserId;
    protected Map<String, Context> contexts = new HashMap<String, Context>();
    protected ArrayList<String> defaultSearchOrderList = new ArrayList();
    protected String[] defaultSearchOrder = null;
    protected Throwable exception;
    protected transient ClassLoader classLoader;

    @Override
    public Context getContext(String contextName) {
        return this.contexts.get(contextName);
    }

    @Override
    public void setContext(Context context) {
        String key = context.getName();
        if (this.contexts.put(key, context) == null) {
            this.defaultSearchOrderList.add(key);
        }
        this.defaultSearchOrder = null;
    }

    @Override
    public Context removeContext(Context context) {
        return this.removeContext(context.getName());
    }

    @Override
    public Context removeContext(String contextName) {
        Context removedContext = this.contexts.remove(contextName);
        if (removedContext != null) {
            this.defaultSearchOrderList.remove(contextName);
            this.defaultSearchOrder = null;
        }
        return removedContext;
    }

    public Context getEnvironmentFactoryContext() {
        return this.getContext("process-engine");
    }

    public Context getEnvironmentContext() {
        return this.getContext("transaction");
    }

    @Override
    public String getAuthenticatedUserId() {
        return this.authenticatedUserId;
    }

    @Override
    public void setAuthenticatedUserId(String authenticatedUserId) {
        this.authenticatedUserId = authenticatedUserId;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Object get(String name) {
        return this.get(name, null);
    }

    @Override
    public Object get(String name, String[] searchOrder) {
        if (searchOrder == null) {
            searchOrder = this.getDefaultSearchOrder();
        }
        for (int i = 0; i < searchOrder.length; ++i) {
            Context context = this.contexts.get(searchOrder[i]);
            if (!context.has(name)) continue;
            return context.get(name);
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.get(type, null);
    }

    @Override
    public <T> T get(Class<T> type, String[] searchOrder) {
        if (searchOrder == null) {
            searchOrder = this.getDefaultSearchOrder();
        }
        for (int i = 0; i < searchOrder.length; ++i) {
            Context context = this.contexts.get(searchOrder[i]);
            T o = context.get(type);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public void close() {
        log.trace("closing " + this);
        EnvironmentImpl popped = EnvironmentImpl.popEnvironment();
        if (this != popped) {
            throw new JbpmException("environment nesting problem");
        }
    }

    protected String[] getDefaultSearchOrder() {
        if (this.defaultSearchOrder == null) {
            int size = this.defaultSearchOrderList.size();
            this.defaultSearchOrder = new String[size];
            for (int i = 0; i < size; ++i) {
                this.defaultSearchOrder[i] = this.defaultSearchOrderList.get(size - 1 - i);
            }
        }
        return this.defaultSearchOrder;
    }
}

