/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.VariableCreate;
import org.jbpm.pvm.internal.id.DbidGenerator;
import org.jbpm.pvm.internal.job.TimerImpl;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ScopeElementImpl;
import org.jbpm.pvm.internal.model.TimerDefinitionImpl;
import org.jbpm.pvm.internal.model.VariableDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.type.Converter;
import org.jbpm.pvm.internal.type.Type;
import org.jbpm.pvm.internal.type.TypeSet;
import org.jbpm.pvm.internal.type.Variable;
import org.jbpm.pvm.internal.type.variable.NullVariable;
import org.jbpm.pvm.internal.type.variable.UnpersistableVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeInstanceImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog((String)ScopeInstanceImpl.class.getName());
    protected long dbid;
    protected int dbversion;
    protected boolean hasVariables;
    protected Map<String, Variable> variables = new HashMap<String, Variable>();
    protected String state;
    protected String suspendHistoryState;

    protected void initializeVariables(ScopeElementImpl scope, ExecutionImpl outerExecution) {
        List<VariableDefinitionImpl> variableDefinitions = scope.getVariableDefinitions();
        if (!variableDefinitions.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("initializing variables in scope " + scope);
            }
            for (VariableDefinitionImpl variableDefinition : variableDefinitions) {
                String key = variableDefinition.getName();
                Object value = variableDefinition.getInitValue(outerExecution);
                String typeName = variableDefinition.getTypeName();
                boolean isHistoryEnabled = variableDefinition.isHistoryEnabled();
                this.createVariable(key, value, typeName, isHistoryEnabled);
            }
        }
    }

    public void createVariable(String key, Object value) {
        this.createVariable(key, value, null, false);
    }

    public void createVariable(String key, Object value, String typeName, boolean isHistoryEnabled) {
        Variable variable = this.createVariableObject(key, value, typeName, isHistoryEnabled);
        this.variables.put(variable.getKey(), variable);
        this.hasVariables = true;
    }

    protected Variable createVariableObject(String key, Object value, String typeName, boolean isHistoryEnabled) {
        TypeSet typeSet;
        log.debug("create variable '" + key + "' in '" + this + "' with value '" + value + "'");
        Type type = null;
        if (type == null && (typeSet = EnvironmentImpl.getFromCurrent(TypeSet.class, false)) != null) {
            if (typeName != null) {
                type = typeSet.findTypeByName(typeName);
            }
            if (type == null) {
                type = typeSet.findTypeByMatch(key, value);
            }
        }
        Variable variable = null;
        if (type != null) {
            Class<?> variableClass = type.getVariableClass();
            try {
                log.trace("creating new " + type + " variable " + key);
                variable = (Variable)variableClass.newInstance();
            }
            catch (Exception e) {
                throw new JbpmException("couldn't instantiate variable instance class '" + variableClass.getName() + "'");
            }
            Converter converter = type.getConverter();
            variable.setConverter(converter);
        } else if (value == null) {
            log.trace("creating null variable for " + key);
            variable = new NullVariable();
        } else {
            log.trace("creating new unpersistable variable for " + key);
            variable = new UnpersistableVariable();
        }
        variable.setKey(key);
        variable.setExecution(this.getExecution());
        variable.setTask(this.getTask());
        variable.setHistoryEnabled(isHistoryEnabled);
        variable.setValue(value);
        long dbid = DbidGenerator.getDbidGenerator().getNextId();
        variable.setDbid(dbid);
        if (isHistoryEnabled) {
            HistoryEvent.fire(new VariableCreate(variable));
        }
        return variable;
    }

    public void setVariable(String key, Object value) {
        if (key == null) {
            throw new JbpmException("variableName is null");
        }
        Variable variable = this.getVariableObject(key);
        if (variable != null && !variable.supports(value)) {
            log.debug("variable type change. deleting '" + key + "' from '" + this + "'");
            this.removeVariable(key);
            variable = null;
        }
        if (variable != null) {
            log.debug("updating variable '" + key + "' in '" + this + "' to value '" + value + "'");
            variable.setValue(value);
        } else if (this.getParentVariableScope() == null) {
            this.createVariable(key, value, null, false);
        } else {
            this.getParentVariableScope().setVariable(key, value);
        }
    }

    public void setVariables(Map<String, ?> variables) {
        if (variables != null) {
            for (Map.Entry<String, ?> entry : variables.entrySet()) {
                this.setVariable(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object getVariable(String key) {
        Variable variable = this.getVariableObject(key);
        if (variable != null) {
            return variable.getValue();
        }
        ScopeInstanceImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getVariable(key);
        }
        return null;
    }

    public Variable getVariableObject(String key) {
        return this.hasVariables ? this.variables.get(key) : null;
    }

    public boolean hasVariable(String key) {
        ScopeInstanceImpl parentScope = this.getParentVariableScope();
        return this.hasVariables && this.variables.containsKey(key) || parentScope != null && parentScope.hasVariable(key);
    }

    public Set<String> getVariableKeys() {
        Set<String> variableKeys = null;
        ScopeInstanceImpl parentScope = this.getParentVariableScope();
        variableKeys = parentScope != null ? parentScope.getVariableKeys() : new TreeSet<String>();
        if (this.hasVariables) {
            variableKeys.addAll(this.variables.keySet());
        }
        return variableKeys;
    }

    public Map<String, Object> getVariables() {
        Map<String, Object> values = null;
        ScopeInstanceImpl parentScope = this.getParentVariableScope();
        values = parentScope != null ? parentScope.getVariables() : new TreeMap<String, Object>();
        if (this.hasVariables) {
            for (Map.Entry<String, Variable> entry : this.variables.entrySet()) {
                String name = entry.getKey();
                Variable variable = entry.getValue();
                Object value = variable.getValue();
                values.put(name, value);
            }
        }
        return values;
    }

    public boolean hasVariables() {
        ScopeInstanceImpl parentScope = this.getParentVariableScope();
        return this.hasVariables || parentScope != null && parentScope.hasVariables();
    }

    public boolean removeVariable(String key) {
        ScopeInstanceImpl parentScope;
        Variable variable = null;
        if (this.hasVariables) {
            variable = this.variables.remove(key);
            if (this.variables.isEmpty()) {
                this.hasVariables = false;
            }
            if (variable != null) {
                return true;
            }
        }
        if ((parentScope = this.getParentVariableScope()) != null) {
            return parentScope.removeVariable(key);
        }
        return false;
    }

    public void removeVariables() {
        if (this.hasVariables) {
            this.variables.clear();
        }
        this.hasVariables = false;
    }

    protected TimerImpl newTimer() {
        return new TimerImpl();
    }

    public TimerImpl createTimer() {
        return this.createTimer(null);
    }

    public TimerImpl createTimer(TimerDefinitionImpl timerDefinition) {
        if (log.isDebugEnabled()) {
            log.debug("creating timer on " + this.toString());
        }
        TimerImpl timer = this.newTimer();
        timer.setExecution(this.getTimerExecution());
        if (timerDefinition != null) {
            Integer retries;
            timer.setEventName(timerDefinition.getEventName());
            timer.setSignalName(timerDefinition.getSignalName());
            timer.setDuedate(timerDefinition.getDueDate());
            timer.setDueDateDescription(timerDefinition.getDueDateDescription());
            Boolean isExclusive = timerDefinition.isExclusive();
            if (isExclusive != null) {
                timer.setExclusive(isExclusive);
            }
            if ((retries = timerDefinition.getRetries()) != null) {
                timer.setRetries(retries);
            }
            timer.setRepeat(timerDefinition.getRepeat());
        }
        return timer;
    }

    protected void initializeTimers(ScopeElementImpl scope) {
        Set<TimerDefinitionImpl> timerDefinitions = scope.getTimerDefinitions();
        if (!timerDefinitions.isEmpty()) {
            for (TimerDefinitionImpl timerDefinition : timerDefinitions) {
                TimerImpl timer = this.createTimer(timerDefinition);
                timer.schedule();
            }
        }
    }

    protected void destroyTimers(CompositeElementImpl scope) {
    }

    public void suspend() {
        if ("suspended".equals(this.state)) {
            return;
        }
        this.suspendHistoryState = this.state;
        this.state = "suspended";
    }

    public void resume() {
        if (!"suspended".equals(this.state)) {
            return;
        }
        this.state = this.suspendHistoryState;
        this.suspendHistoryState = null;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public boolean isActive() {
        return "active-root".equals(this.state) || "active-concurrent".equals(this.state);
    }

    public boolean isSuspended() {
        return "suspended".equals(this.state);
    }

    public ExecutionImpl getExecution() {
        return null;
    }

    public TaskImpl getTask() {
        return null;
    }

    public ExecutionImpl getTimerExecution() {
        return null;
    }

    public ScopeInstanceImpl getParentVariableScope() {
        return null;
    }

    public long getDbid() {
        return this.dbid;
    }
}

