/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.jbpm.api.history.HistoryTask;
import org.jbpm.api.history.HistoryTaskQuery;
import org.jbpm.pvm.internal.history.model.HistoryTaskImpl;
import org.jbpm.pvm.internal.query.AbstractQuery;
import org.jbpm.pvm.internal.query.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryTaskQueryImpl
extends AbstractQuery
implements HistoryTaskQuery {
    protected String taskId;
    protected String executionId;
    protected String assignee;
    protected String state;
    protected String outcome;
    protected Long tookLessThen;
    protected Long tookLongerThen;
    protected Date startedBefore;
    protected Date startedAfter;

    @Override
    public String hql() {
        StringBuilder hql = new StringBuilder();
        hql.append("select ht ");
        hql.append("from ");
        hql.append(HistoryTaskImpl.class.getName());
        hql.append(" as ht ");
        if (this.taskId != null) {
            this.appendWhereClause(" ht.dbid = " + this.taskId + " ", hql);
        }
        if (this.executionId != null) {
            this.appendWhereClause(" ht.executionId = '" + this.executionId + "' ", hql);
        }
        if (this.assignee != null) {
            this.appendWhereClause(" ht.assignee = '" + this.assignee + "' ", hql);
        }
        if (this.state != null) {
            this.appendWhereClause(" ht.state = '" + this.state + "' ", hql);
        }
        if (this.outcome != null) {
            this.appendWhereClause(" ht.outcome = '" + this.outcome + "' ", hql);
        }
        if (this.tookLessThen != null) {
            this.appendWhereClause(" ht.duration < :tookLessThen ", hql);
        }
        if (this.tookLongerThen != null) {
            this.appendWhereClause(" ht.duration > :tookLongerThen ", hql);
        }
        if (this.startedBefore != null) {
            this.appendWhereClause(" ht.startTime < :startedBefore ", hql);
        }
        if (this.startedAfter != null) {
            this.appendWhereClause(" ht.startTime > :startedAfter ", hql);
        }
        this.appendOrderByClause(hql);
        return hql.toString();
    }

    @Override
    protected void applyParameters(Query query) {
        if (this.tookLessThen != null) {
            query.setLong("tookLessThen", this.tookLessThen.longValue());
        }
        if (this.tookLongerThen != null) {
            query.setLong("tookLongerThen", this.tookLongerThen.longValue());
        }
        if (this.startedBefore != null) {
            query.setTime("startedBefore", this.startedBefore);
        }
        if (this.startedAfter != null) {
            query.setTime("startedAfter", this.startedAfter);
        }
    }

    public List<HistoryTask> list() {
        return this.untypedList();
    }

    public HistoryTask uniqueResult() {
        return (HistoryTask)this.untypedUniqueResult();
    }

    public HistoryTaskQuery taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public HistoryTaskQuery executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public HistoryTaskQuery assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public HistoryTaskQuery state(String state) {
        this.state = state;
        return this;
    }

    public HistoryTaskQuery outcome(String outcome) {
        this.outcome = outcome;
        return this;
    }

    public HistoryTaskQuery orderAsc(String property) {
        this.addOrderByClause("ht." + property + " asc");
        return this;
    }

    public HistoryTaskQuery orderDesc(String property) {
        this.addOrderByClause("ht." + property + " desc");
        return this;
    }

    public HistoryTaskQuery page(int firstResult, int maxResults) {
        this.page = new Page(firstResult, maxResults);
        return this;
    }

    public HistoryTaskQuery startedAfter(Date time) {
        this.startedAfter = time;
        return this;
    }

    public HistoryTaskQuery startedBefore(Date time) {
        this.startedBefore = time;
        return this;
    }

    public HistoryTaskQuery tookLessThen(long durationInMillis) {
        this.tookLessThen = durationInMillis;
        return this;
    }

    public HistoryTaskQuery tookLongerThen(long durationInMillis) {
        this.tookLongerThen = durationInMillis;
        return this;
    }
}

