/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.stream;

import java.io.InputStream;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.stream.StreamInput;

public class ResourceStreamInput
extends StreamInput {
    protected ClassLoader classLoader;
    protected String resource;

    public ResourceStreamInput(String resource) {
        this(resource, null);
    }

    public ResourceStreamInput(String resource, ClassLoader classLoader) {
        if (resource == null) {
            throw new JbpmException("resource is null");
        }
        this.name = "resource://" + resource;
        this.resource = resource;
        this.classLoader = classLoader;
    }

    public InputStream openStream() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream stream = classLoader.getResourceAsStream(this.resource);
        if (stream == null) {
            throw new JbpmException("resource " + this.resource + " does not exist");
        }
        return stream;
    }
}

