/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.tx;

import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.spring.CommandTransactionCallback;
import org.jbpm.pvm.internal.svc.Interceptor;
import org.jbpm.pvm.internal.tx.StandardTransaction;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTransactionInterceptor
extends Interceptor {
    private static final Log log = Log.getLog((String)SpringTransactionInterceptor.class.getName());
    private boolean useCurrent;

    @Override
    public <T> T execute(Command<T> command) {
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        if (environment == null) {
            throw new JbpmException("no environment for managing hibernate transaction");
        }
        StandardTransaction standardTransaction = environment.get(StandardTransaction.class);
        PlatformTransactionManager platformTransactionManager = environment.get(PlatformTransactionManager.class);
        if (platformTransactionManager == null) {
            throw new JbpmException("No platformTransaction manager defined.");
        }
        if (standardTransaction != null) {
            standardTransaction.begin();
        }
        try {
            TransactionTemplate template = new TransactionTemplate(platformTransactionManager);
            if (this.useCurrent) {
                template.setPropagationBehavior(2);
            } else {
                template.setPropagationBehavior(0);
            }
            CommandTransactionCallback<T> transactionCallback = new CommandTransactionCallback<T>(command, this.next, platformTransactionManager);
            Object t = template.execute(transactionCallback);
            Session session = environment.get(Session.class);
            if (session.isOpen()) {
                session.flush();
            }
            Object object = t;
            return (T)object;
        }
        catch (RuntimeException e) {
            if (standardTransaction != null) {
                standardTransaction.setRollbackOnly();
            }
            throw e;
        }
        finally {
            if (standardTransaction != null) {
                standardTransaction.complete();
            }
        }
    }

    public void setUseCurrent(Boolean useCurrent) {
        this.useCurrent = useCurrent;
    }
}

