/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.type.matcher;

import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.type.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateIdMatcher
implements Matcher {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog((String)HibernateIdMatcher.class.getName());
    String hibernateSessionFactoryName;

    public HibernateIdMatcher(String hibernateSessionFactoryName) {
        this.hibernateSessionFactoryName = hibernateSessionFactoryName;
    }

    protected abstract Class<? extends Type> getIdType();

    @Override
    public boolean matches(String name, Object value) {
        boolean matches = false;
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        if (environment != null) {
            SessionFactory sessionFactory = null;
            sessionFactory = this.hibernateSessionFactoryName != null ? (SessionFactory)environment.get(this.hibernateSessionFactoryName) : environment.get(SessionFactory.class);
            if (sessionFactory != null) {
                ClassMetadata classMetadata = sessionFactory.getClassMetadata(value.getClass());
                matches = classMetadata != null && classMetadata.getIdentifierType().getClass() == this.getIdType();
            }
        } else {
            log.trace("no current environment so valueClass cannot be stored as an id-ref to a hibernate object");
            matches = false;
        }
        return matches;
    }

    public String getHibernateSessionFactoryName() {
        return this.hibernateSessionFactoryName;
    }

    public void setHibernateSessionFactoryName(String hibernateSessionFactoryName) {
        this.hibernateSessionFactoryName = hibernateSessionFactoryName;
    }
}

