/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.IntegerDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.JobExecutorDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ReferenceDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.StringDescriptor;
import org.jbpm.pvm.internal.wire.operation.InvokeOperation;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class JobExecutorBinding
extends WireDescriptorBinding {
    public JobExecutorBinding() {
        super("job-executor");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        JobExecutorDescriptor descriptor = new JobExecutorDescriptor();
        if (element.hasAttribute("command-service")) {
            descriptor.addInjection("commandService", new ReferenceDescriptor(element.getAttribute("command-service")));
        } else {
            descriptor.addInjection("commandService", new ReferenceDescriptor("txRequiredCommandService"));
        }
        if (element.hasAttribute("name")) {
            descriptor.addInjection("name", new StringDescriptor(element.getAttribute("name")));
        }
        this.parseIntAttribute(element, "threads", descriptor, "nbrOfThreads", parse);
        this.parseIntAttribute(element, "idle", descriptor, "idleMillis", parse);
        this.parseIntAttribute(element, "idle-max", descriptor, "idleMillisMax", parse);
        this.parseIntAttribute(element, "history", descriptor, "historySize", parse);
        this.parseIntAttribute(element, "lock", descriptor, "lockMillis", parse);
        if (XmlUtil.attributeBoolean(element, "auto-start", false, parse, true).booleanValue()) {
            InvokeOperation invokeStartOperation = new InvokeOperation();
            invokeStartOperation.setMethodName("start");
            descriptor.addOperation(invokeStartOperation);
            descriptor.setAutoStart(true);
            descriptor.setInit('E');
        }
        return descriptor;
    }

    private void parseIntAttribute(Element element, String attributeName, ObjectDescriptor descriptor, String fieldName, Parse parse) {
        Integer intValue = XmlUtil.attributeInteger(element, attributeName, false, parse);
        if (intValue != null) {
            descriptor.addInjection(fieldName, new IntegerDescriptor(intValue));
        }
    }
}

