/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class TopSelfFactory {
    private TopSelfFactory() {
    }

    public static IRubyObject createTopSelf(Ruby runtime) {
        return TopSelfFactory.createTopSelf(runtime, false);
    }

    public static IRubyObject createTopSelf(final Ruby runtime, boolean wrapper) {
        RubyObject topSelf = new RubyObject(runtime, runtime.getObject());
        final RubyClass singletonClass = topSelf.getSingletonClass();
        singletonClass.addMethod("to_s", new JavaMethod.JavaMethodZero((RubyModule)singletonClass, Visibility.PUBLIC, "to_s"){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                return runtime.newString("main");
            }
        });
        singletonClass.defineAlias("inspect", "to_s");
        singletonClass.addMethod("include", new JavaMethod.JavaMethodN((RubyModule)singletonClass, Visibility.PRIVATE, "include"){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
                return context.runtime.getObject().include(args2);
            }
        });
        singletonClass.addMethod("public", new JavaMethod.JavaMethodN((RubyModule)singletonClass, Visibility.PRIVATE, "public"){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
                return context.runtime.getObject().rbPublic(context, args2);
            }
        });
        singletonClass.addMethod("private", new JavaMethod.JavaMethodN((RubyModule)singletonClass, Visibility.PRIVATE, "private"){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
                return context.runtime.getObject().rbPrivate(context, args2);
            }
        });
        final RubyClass klass = wrapper ? singletonClass : runtime.getObject();
        singletonClass.addMethod("define_method", new JavaMethod.JavaMethodOneOrTwoBlock(singletonClass, Visibility.PRIVATE, "define_method"){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
                if (klass == singletonClass) {
                    TopSelfFactory.warnWrapper(context);
                }
                return klass.defineMethodFromBlock(context, arg0, block, Visibility.PUBLIC);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
                if (klass == singletonClass) {
                    TopSelfFactory.warnWrapper(context);
                }
                return klass.defineMethodFromCallable(context, arg0, arg1, Visibility.PUBLIC);
            }
        });
        singletonClass.addMethod("using", new JavaMethod.JavaMethodN((RubyModule)singletonClass, Visibility.PRIVATE, "using"){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
                Arity.checkArgumentCount(context.runtime, args2, 1, 1);
                RubyModule cref = context.getCurrentStaticScope().getOverlayModuleForWrite(context);
                RubyModule.usingModule(context, cref, args2[0]);
                return self2;
            }
        });
        return topSelf;
    }

    private static void warnWrapper(ThreadContext context) {
        context.runtime.getWarnings().warning("main.define_method in the wrapped load is effective only in wrapper module");
    }
}

