/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jcodings.Encoding;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class BuildCompoundStringInstr
extends NOperandResultBaseInstr {
    private final Encoding encoding;
    private final boolean frozen;
    private final String file;
    private final int line;

    public BuildCompoundStringInstr(Variable result2, Operand[] pieces, Encoding encoding2, boolean frozen, String file2, int line) {
        super(Operation.BUILD_COMPOUND_STRING, result2, pieces);
        this.encoding = encoding2;
        this.frozen = frozen;
        this.file = file2;
        this.line = line;
    }

    public Operand[] getPieces() {
        return this.getOperands();
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildCompoundStringInstr(ii.getRenamedVariable(this.result), this.cloneOperands(ii), this.encoding, this.frozen, this.file, this.line);
    }

    public boolean isSameEncodingAndCodeRange(RubyString str, StringLiteral newStr) {
        return newStr.getByteList().getEncoding() == this.encoding && newStr.getCodeRange() == str.getCodeRange();
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getPieces());
        e.encode(this.encoding);
        e.encode(this.frozen);
        e.encode(this.file);
        e.encode(this.line);
    }

    public static BuildCompoundStringInstr decode(IRReaderDecoder d) {
        return new BuildCompoundStringInstr(d.decodeVariable(), d.decodeOperandArray(), d.decodeEncoding(), d.decodeBoolean(), d.decodeString(), d.decodeInt());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        ByteList bytes2 = new ByteList();
        bytes2.setEncoding(this.encoding);
        RubyString str = RubyString.newStringShared(context.runtime, bytes2, 16);
        for (Operand p2 : this.getOperands()) {
            if (p2 instanceof StringLiteral && this.isSameEncodingAndCodeRange(str, (StringLiteral)p2)) {
                str.getByteList().append(((StringLiteral)p2).getByteList());
                str.setCodeRange(((StringLiteral)p2).getCodeRange());
                continue;
            }
            IRubyObject pval = (IRubyObject)p2.retrieve(context, self2, currScope, currDynScope, temp);
            str.append19(pval);
        }
        return this.frozen ? IRRuntimeHelpers.freezeLiteralString(context, str, this.file, this.line) : str;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildCompoundStringInstr(this);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }
}

