/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.filtering;

import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.filtering.FilteringConfigurer;
import de.danielbechler.diff.filtering.IsReturnableResolver;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.util.Collections;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReturnableNodeService
implements FilteringConfigurer,
IsReturnableResolver {
    private final Map<DiffNode.State, Boolean> stateFilterSettings;
    private final ObjectDifferBuilder objectDifferBuilder;

    public ReturnableNodeService(ObjectDifferBuilder objectDifferBuilder) {
        this.objectDifferBuilder = objectDifferBuilder;
        this.stateFilterSettings = new EnumMap<DiffNode.State, Boolean>(DiffNode.State.class);
        this.stateFilterSettings.put(DiffNode.State.IGNORED, false);
        this.stateFilterSettings.put(DiffNode.State.INACCESSIBLE, false);
        this.stateFilterSettings.put(DiffNode.State.UNTOUCHED, false);
        this.stateFilterSettings.put(DiffNode.State.CIRCULAR, true);
        this.stateFilterSettings.put(DiffNode.State.ADDED, true);
        this.stateFilterSettings.put(DiffNode.State.REMOVED, true);
        this.stateFilterSettings.put(DiffNode.State.CHANGED, true);
        this.assertDefaultValuesForAllAvailableStates();
    }

    private void assertDefaultValuesForAllAvailableStates() {
        Set<DiffNode.State> statesWithDefaultValue;
        List<DiffNode.State> availableStates = Arrays.asList(DiffNode.State.values());
        Collection<DiffNode.State> statesWithoutDefaultValue = Collections.filteredCopyOf(availableStates, statesWithDefaultValue = this.stateFilterSettings.keySet());
        if (!statesWithoutDefaultValue.isEmpty()) {
            throw new IllegalStateException("Missing default value for states: " + statesWithoutDefaultValue);
        }
    }

    @Override
    public boolean isReturnable(DiffNode node) {
        if (node.isRootNode()) {
            return true;
        }
        if (node.isUntouched() && node.hasChildren()) {
            return true;
        }
        return this.stateFilterSettings.get((Object)node.getState());
    }

    @Override
    public ReturnableNodeService returnNodesWithState(DiffNode.State state, boolean enabled) {
        this.stateFilterSettings.put(state, enabled);
        return this;
    }

    @Override
    public ReturnableNodeService returnNodesWithState(DiffNode.State state) {
        return this.returnNodesWithState(state, true);
    }

    @Override
    public ReturnableNodeService omitNodesWithState(DiffNode.State state) {
        return this.returnNodesWithState(state, false);
    }

    @Override
    public ObjectDifferBuilder and() {
        return this.objectDifferBuilder;
    }
}

